/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.CABenchmark;
import cambria.CAConfig;
import cambria.CAConfigBase;
import cambria.CAPattern;
import cambria.CAPhenotype;
import cambria.CARule;
import cambria.EntroS;
import cambria.Partition;
import cambria.StochasticPartitionRule;
import cambria.misc.MyFileWriter;
import cambria.stat.Statistic;
import cambria.stat.TimeSeriesAnalysis;

public class CABatch {
    public static void executeBatchJob(CAConfig caConfig, int jobNumber, String runNumber, int t_max) {
        if (jobNumber == 1) {
            CABenchmark.printElaspedTime(caConfig, t_max);
        } else if (jobNumber == 2) {
            CABatch.getHsWhileTransient(caConfig, t_max);
        } else if (jobNumber == 3) {
            CABatch.evolve(caConfig, 100, null);
        } else if (jobNumber == 5) {
            CABatch.physicadPhase(caConfig);
        } else if (jobNumber == 6) {
            CABatch.physicadPhase(caConfig, 0.3);
        } else if (jobNumber == 7) {
            CABatch.getTransientLength(caConfig, t_max);
        } else if (jobNumber == 8) {
            CABatch.saveHsAfterEvolve(caConfig, t_max);
        } else if (jobNumber == 9) {
            System.out.println("Type " + CABatch.derivePatternType(caConfig, t_max));
        } else {
            throw new RuntimeException("Invalid job number.");
        }
        System.exit(0);
    }

    public static int derivePatternType(CAConfigBase caConfig) {
        if (caConfig == null) {
            throw new IllegalArgumentException("null caConfig");
        }
        int type = 0;
        Partition refPattern1 = new Partition(9);
        refPattern1.setWnState((byte)0);
        refPattern1.setNorthState((byte)1);
        refPattern1.setNeState((byte)0);
        refPattern1.setWestState((byte)1);
        refPattern1.setHomeState((byte)0);
        refPattern1.setEastState((byte)1);
        refPattern1.setSwState((byte)0);
        refPattern1.setSouthState((byte)1);
        refPattern1.setEsState((byte)0);
        Partition refPattern2 = new Partition(9);
        refPattern2.setWnState((byte)1);
        refPattern2.setNorthState((byte)1);
        refPattern2.setNeState((byte)1);
        refPattern2.setWestState((byte)0);
        refPattern2.setHomeState((byte)0);
        refPattern2.setEastState((byte)0);
        refPattern2.setSwState((byte)1);
        refPattern2.setSouthState((byte)1);
        refPattern2.setEsState((byte)1);
        Partition refPattern4 = new Partition(9);
        refPattern4.setWnState((byte)1);
        refPattern4.setNorthState((byte)0);
        refPattern4.setNeState((byte)1);
        refPattern4.setWestState((byte)1);
        refPattern4.setHomeState((byte)0);
        refPattern4.setEastState((byte)1);
        refPattern4.setSwState((byte)1);
        refPattern4.setSouthState((byte)0);
        refPattern4.setEsState((byte)1);
        Partition refPattern3 = new Partition(9);
        refPattern3.setWnState((byte)1);
        refPattern3.setNorthState((byte)1);
        refPattern3.setNeState((byte)1);
        refPattern3.setWestState((byte)1);
        refPattern3.setHomeState((byte)1);
        refPattern3.setEastState((byte)1);
        refPattern3.setSwState((byte)1);
        refPattern3.setSouthState((byte)1);
        refPattern3.setEsState((byte)1);
        double count1 = CAPattern.count33PatternRatio(caConfig.getCAState(), refPattern1);
        double count2 = CAPattern.count33PatternRatio(caConfig.getCAState(), refPattern2);
        double count3 = CAPattern.count33PatternRatio(caConfig.getCAState(), refPattern3);
        double count4 = CAPattern.count33PatternRatio(caConfig.getCAState(), refPattern4);
        type = count1 > count2 + count4 ? (count1 > count3 ? 1 : 3) : (count2 + count4 > count3 ? 2 : 3);
        return type;
    }

    public static int derivePatternType(CAConfig caConfig, int t_max) {
        if (caConfig == null) {
            throw new IllegalArgumentException("null caConfig");
        }
        CABatch.evolve(caConfig, t_max, null);
        return CABatch.derivePatternType(caConfig);
    }

    public static void getTransientLength(CAConfig caConfig1, int t_max) {
        CAConfig caConfig = caConfig1;
        CARule rule = caConfig.getCARule();
        int runPerCase = 1000;
        int maxCase = 100;
        double[] averagedTransientLength = new double[maxCase];
        double density = 0.5;
        int imobility = 0;
        for (int i = 0; i < maxCase; ++i) {
            double mobility = (double)(++imobility) / 100.0;
            ((StochasticPartitionRule)rule).setAllTransitionProbability(mobility);
            int sumTransientLength = 0;
            for (int j = 0; j < runPerCase; ++j) {
                caConfig.randomize(density);
                float[] timeSeries = CABatch.getHsWhileTransient(caConfig, t_max);
                sumTransientLength += timeSeries.length;
            }
            averagedTransientLength[i] = (double)sumTransientLength / (double)runPerCase;
            System.out.println(" " + i + " " + averagedTransientLength[i]);
        }
        double[] xData = new double[maxCase];
        for (int t = 0; t < maxCase; ++t) {
            xData[t] = t + 1;
        }
        MyFileWriter.saveData("physicaA03.dat", null, xData, averagedTransientLength);
        System.exit(0);
    }

    public static void physicadPhase(CAConfig caConfig, double mobility) {
        CARule rule = caConfig.getCARule();
        int runPerCase = 1000;
        int t_max = 250;
        int t_tran = 200;
        int t_av = t_max - t_tran;
        float[][] fdata = new float[2][runPerCase];
        Partition refPattern = new Partition(9);
        refPattern.setWnState((byte)0);
        refPattern.setNorthState((byte)1);
        refPattern.setNeState((byte)0);
        refPattern.setWestState((byte)1);
        refPattern.setHomeState((byte)0);
        refPattern.setEastState((byte)1);
        refPattern.setSwState((byte)0);
        refPattern.setSouthState((byte)1);
        refPattern.setEsState((byte)0);
        double density = 0.5;
        ((StochasticPartitionRule)rule).setAllTransitionProbability(mobility);
        double[] tempActiveRatio = new double[runPerCase];
        double[] tempFidelity = new double[runPerCase];
        for (int j = 0; j < runPerCase; ++j) {
            caConfig.randomize(density);
            double[][] timeSeries = CABatch.getActiveRatioFidelity(caConfig, refPattern, t_max);
            double sumActiveRaio = 0.0;
            double sumFidelity = 0.0;
            for (int k = 0; k < t_av; ++k) {
                sumActiveRaio += timeSeries[0][t_max - 1 - k];
                sumFidelity += timeSeries[1][t_max - 1 - k];
            }
            fdata[0][j] = (float)(sumActiveRaio / (double)t_av);
            fdata[1][j] = (float)(sumFidelity / (double)t_av);
            System.out.println(j);
        }
        float[] xData = new float[runPerCase];
        for (int t = 0; t < runPerCase; ++t) {
            xData[t] = t + 1;
        }
        MyFileWriter.saveData("physicaA02.dat", null, xData, fdata);
        System.exit(0);
    }

    public static void physicadPhase(CAConfig caConfig) {
        CARule rule = caConfig.getCARule();
        int runPerCase = 500;
        int maxCase = 100;
        int t_max = 250;
        int t_tran = 200;
        int t_av = t_max - t_tran;
        int imobility = 0;
        float[][] activeRatioFidelity = new float[4][maxCase];
        Partition refPattern = new Partition(9);
        refPattern.setWnState((byte)0);
        refPattern.setNorthState((byte)1);
        refPattern.setNeState((byte)0);
        refPattern.setWestState((byte)1);
        refPattern.setHomeState((byte)0);
        refPattern.setEastState((byte)1);
        refPattern.setSwState((byte)0);
        refPattern.setSouthState((byte)1);
        refPattern.setEsState((byte)0);
        double density = 0.5;
        for (int i = 0; i < maxCase; ++i) {
            double mobility = (double)(++imobility) / 100.0;
            ((StochasticPartitionRule)rule).setAllTransitionProbability(mobility);
            double[] tempActiveRatio = new double[runPerCase];
            double[] tempFidelity = new double[runPerCase];
            for (int j = 0; j < runPerCase; ++j) {
                caConfig.randomize(density);
                double[][] timeSeries = CABatch.getActiveRatioFidelity(caConfig, refPattern, t_max);
                double sumActiveRaio = 0.0;
                double sumFidelity = 0.0;
                for (int k = 0; k < t_av; ++k) {
                    sumActiveRaio += timeSeries[0][t_max - 1 - k];
                    sumFidelity += timeSeries[1][t_max - 1 - k];
                }
                tempActiveRatio[j] = sumActiveRaio / (double)t_av;
                tempFidelity[j] = sumFidelity / (double)t_av;
            }
            activeRatioFidelity[0][i] = (float)Statistic.average(tempActiveRatio);
            activeRatioFidelity[1][i] = (float)Statistic.average(tempFidelity);
            activeRatioFidelity[2][i] = (float)Statistic.stddev(tempActiveRatio);
            activeRatioFidelity[3][i] = (float)Statistic.stddev(tempFidelity);
            System.out.println(" " + i + " " + activeRatioFidelity[0][i] + " " + activeRatioFidelity[1][i]);
        }
        float[] xData = new float[maxCase];
        for (int t = 0; t < maxCase; ++t) {
            xData[t] = t + 1;
        }
        MyFileWriter.saveData("physicaA01.dat", null, xData, activeRatioFidelity);
        System.exit(0);
    }

    public static float[] getHsWhileTransient(CAConfig caConfig, int t_max) {
        System.out.println(" -- This method is deprecated. Use CAPhenotype for the first argument.");
        int window = 3;
        float epsiron = 0.003f;
        float[] entropyTimeSeries = new float[t_max];
        int transientTime = t_max;
        int i = 0;
        boolean isTransient = true;
        do {
            byte[][] prevState = caConfig.getCAState();
            entropyTimeSeries[i] = EntroS.getEntro(prevState, caConfig.getStatePerCell());
            if (i >= window && isTransient && !(isTransient = TimeSeriesAnalysis.checkIfTransient(entropyTimeSeries, i, window, epsiron))) {
                transientTime = i - window + 1;
            }
            caConfig.step();
            byte[][] caState = caConfig.getCAState();
            double nextEntropy = EntroS.getEntro(caState, caConfig.getStatePerCell());
        } while (++i < t_max && isTransient);
        float[] entropyTimeSeries2 = new float[transientTime];
        for (int j = 0; j < transientTime; ++j) {
            entropyTimeSeries2[j] = entropyTimeSeries[j];
        }
        return entropyTimeSeries2;
    }

    public static float[] getHsWhileTransient(CAPhenotype caPhenotype, int t_max) {
        int window = 3;
        float epsiron = 0.003f;
        float[] entropyTimeSeries = new float[t_max];
        int transientTime = t_max;
        int i = 0;
        boolean isTransient = true;
        do {
            byte[][] prevState = caPhenotype.getCAState();
            entropyTimeSeries[i] = EntroS.getEntro(prevState, caPhenotype.getStatePerCell());
            if (i >= window && isTransient && !(isTransient = TimeSeriesAnalysis.checkIfTransient(entropyTimeSeries, i, window, epsiron))) {
                transientTime = i - window + 1;
            }
            caPhenotype.step();
            byte[][] caState = caPhenotype.getCAState();
            double nextEntropy = EntroS.getEntro(caState, caPhenotype.getStatePerCell());
        } while (++i < t_max && isTransient);
        float[] entropyTimeSeries2 = new float[transientTime];
        for (int j = 0; j < transientTime; ++j) {
            entropyTimeSeries2[j] = entropyTimeSeries[j];
        }
        return entropyTimeSeries2;
    }

    public static void saveHsAfterEvolve(CAConfig caConfig, int tmax) {
        float[][] hs = new float[100][20];
        float[] xData = new float[20];
        for (int i = 0; i < 20; ++i) {
            double density = 0.1 + (double)i / 200.0;
            xData[i] = (float)density;
            System.out.println("Density = " + density);
            for (int j = 0; j < 100; ++j) {
                caConfig.randomize(density);
                hs[j][i] = CABatch.getHsAfterEvolve(caConfig, tmax);
            }
        }
        MyFileWriter.saveData("nlp10.dat", null, xData, hs);
    }

    public static float getHsAfterEvolve(CAConfig caConfig, int t_max) {
        for (int i = 0; i < t_max; ++i) {
            caConfig.step();
        }
        return EntroS.getEntro(caConfig.getCAState(), caConfig.getStatePerCell());
    }

    public static void evolve(CAConfig caConfig, int t_max, String fileName) {
        for (int i = 0; i < t_max; ++i) {
            caConfig.step();
        }
        if (fileName != null) {
            MyFileWriter.saveMatrix(fileName, caConfig.getCAState());
        }
    }

    public static float[] getActiveRatio(CAConfig caConfig, int timeSpan) {
        int x_max = caConfig.getXMax();
        int y_max = caConfig.getYMax();
        byte[][] previousState = new byte[x_max][y_max];
        float[] activeParticleRatio = new float[timeSpan];
        for (int t = 0; t < timeSpan; ++t) {
            int j;
            int i;
            for (i = 0; i < x_max; ++i) {
                for (j = 0; j < y_max; ++j) {
                    previousState[i][j] = caConfig.getCAState(i, j);
                }
            }
            caConfig.step();
            int totalActiveParticle = 0;
            int totalParticle = 0;
            for (i = 0; i < x_max; ++i) {
                for (j = 0; j < y_max; ++j) {
                    if (previousState[i][j] <= 0) continue;
                    ++totalParticle;
                    if (previousState[i][j] == caConfig.getCAState(i, j)) continue;
                    ++totalActiveParticle;
                }
            }
            activeParticleRatio[t] = (float)totalActiveParticle / (float)totalParticle;
        }
        return activeParticleRatio;
    }

    public static double[][] getActiveRatioFidelity(CAConfig caConfig, Partition refPattern, int timeSpan) {
        int x_max = caConfig.getXMax();
        int y_max = caConfig.getYMax();
        byte[][] previousState = new byte[x_max][y_max];
        double[][] activeRatioFidelity = new double[2][timeSpan];
        for (int t = 0; t < timeSpan; ++t) {
            int j;
            int i;
            for (i = 0; i < x_max; ++i) {
                for (j = 0; j < y_max; ++j) {
                    previousState[i][j] = caConfig.getCAState(i, j);
                }
            }
            caConfig.step();
            int totalActiveParticle = 0;
            int totalParticle = 0;
            for (i = 0; i < x_max; ++i) {
                for (j = 0; j < y_max; ++j) {
                    if (previousState[i][j] <= 0) continue;
                    ++totalParticle;
                    if (previousState[i][j] == caConfig.getCAState(i, j)) continue;
                    ++totalActiveParticle;
                }
            }
            activeRatioFidelity[0][t] = (double)totalActiveParticle / (double)totalParticle;
            activeRatioFidelity[1][t] = CAPattern.count33PatternRatio(caConfig.getCAState(), refPattern) * 2.0;
        }
        return activeRatioFidelity;
    }

    public static float[][] getHsAndHc(CAConfig caConfig, int timeSpan) {
        CARule rule = caConfig.getCARule();
        int x_max = caConfig.getXMax();
        int y_max = caConfig.getYMax();
        byte[][] changeState = new byte[x_max][y_max];
        float[][] hs = new float[2][timeSpan];
        EntroS entroS1 = new EntroS(rule.getStatePerCell(), x_max, y_max);
        EntroS entroS2 = new EntroS(2, x_max, y_max);
        for (int t = 0; t < timeSpan; ++t) {
            int j;
            int i;
            for (i = 0; i < x_max; ++i) {
                for (j = 0; j < y_max; ++j) {
                    changeState[i][j] = caConfig.getCAState(i, j);
                }
            }
            caConfig.step();
            for (i = 0; i < x_max; ++i) {
                for (j = 0; j < y_max; ++j) {
                    changeState[i][j] = caConfig.getCAState(i, j) == changeState[i][j] ? (byte)0 : 1;
                }
            }
            entroS1.setCA(caConfig.getCAState());
            hs[0][t] = entroS1.getEntro();
            entroS2.setCA(changeState);
            hs[1][t] = entroS2.getEntro();
        }
        return hs;
    }
}

