/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.misc.MyMath;

public class Block9
extends BlockOfCells {
    private static final int HOME = 0;
    private static final int NORTH = 1;
    private static final int WEST = 2;
    private static final int EAST = 3;
    private static final int SOUTH = 4;
    private static final int NORTHEAST = 5;
    private static final int SOUTHEAST = 6;
    private static final int SOUTHWEST = 7;
    private static final int NORTHWEST = 8;
    private static final int maxNeighbor = 9;
    private byte[] neighborState = new byte[9];
    private int x;
    private int y;
    private boolean torus = true;
    private int x_max;
    private int y_max;

    public Block9() {
    }

    public Block9(boolean torus, int x_max, int y_max) {
        this.torus = torus;
        this.x_max = x_max;
        this.y_max = y_max;
    }

    public Block9(int x_max, int y_max) {
        this.x_max = x_max;
        this.y_max = y_max;
    }

    public Block9(Block9 partition) {
        this.neighborState[0] = partition.getHomeState();
        this.neighborState[1] = partition.getNorthState();
        this.neighborState[3] = partition.getEastState();
        this.neighborState[4] = partition.getSouthState();
        this.neighborState[2] = partition.getWestState();
        this.neighborState[5] = partition.getNeState();
        this.neighborState[6] = partition.getEsState();
        this.neighborState[7] = partition.getSwState();
        this.neighborState[8] = partition.getWnState();
        this.torus = partition.isTorus();
    }

    @Override
    public void make(byte[][] caState, int x, int y) {
        this.x = x;
        this.y = y;
        if (this.torus) {
            int east = (x + 1) % this.x_max;
            int south = (y + 1) % this.y_max;
            int west = (x - 1 + this.x_max) % this.x_max;
            int north = (y - 1 + this.y_max) % this.y_max;
            this.neighborState[0] = caState[x][y];
            this.neighborState[1] = caState[x][north];
            this.neighborState[3] = caState[east][y];
            this.neighborState[4] = caState[x][south];
            this.neighborState[2] = caState[west][y];
            this.neighborState[6] = caState[east][south];
            this.neighborState[5] = caState[east][north];
            this.neighborState[7] = caState[west][south];
            this.neighborState[8] = caState[west][north];
        } else {
            int east = x + 1;
            int south = y + 1;
            int north = y - 1;
            int west = x - 1;
            this.setHomeState(caState[x][y]);
            try {
                this.setEastState(caState[east][y]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setEastState((byte)0);
            }
            try {
                this.setSouthState(caState[x][south]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setSouthState((byte)0);
            }
            try {
                this.setNorthState(caState[x][north]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setNorthState((byte)0);
            }
            try {
                this.setWestState(caState[west][y]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setWestState((byte)0);
            }
            try {
                this.setNorthState(caState[x][north]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setEsState((byte)0);
            }
            try {
                this.setNeState(caState[east][north]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setNeState((byte)0);
            }
            try {
                this.setSwState(caState[west][south]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setSwState((byte)0);
            }
            try {
                this.setWnState(caState[west][north]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setWnState((byte)0);
            }
        }
    }

    @Override
    public void setTorus(boolean torus) {
        this.torus = torus;
    }

    @Override
    public boolean isTorus() {
        return this.torus;
    }

    @Override
    public void updateCAState(byte[][] caState, int x, int y) {
        int east = (x + 1) % this.x_max;
        int south = (y + 1) % this.y_max;
        int west = (x - 1 + this.x_max) % this.x_max;
        int north = (y - 1 + this.y_max) % this.y_max;
        caState[x][y] = this.neighborState[0];
        caState[east][y] = this.neighborState[3];
        caState[x][south] = this.neighborState[4];
        caState[x][north] = this.neighborState[1];
        caState[west][y] = this.neighborState[2];
        caState[east][south] = this.neighborState[6];
        caState[east][north] = this.neighborState[5];
        caState[west][south] = this.neighborState[7];
        caState[west][north] = this.neighborState[8];
    }

    @Override
    public byte[] getNeighborState() {
        return this.neighborState;
    }

    public byte getHomeState() {
        return this.neighborState[0];
    }

    public byte getNorthState() {
        return this.neighborState[1];
    }

    public byte getEastState() {
        return this.neighborState[3];
    }

    public byte getSouthState() {
        return this.neighborState[4];
    }

    public byte getWestState() {
        return this.neighborState[2];
    }

    public byte getNeState() {
        return this.neighborState[5];
    }

    public byte getEsState() {
        return this.neighborState[6];
    }

    public byte getSwState() {
        return this.neighborState[7];
    }

    public byte getWnState() {
        return this.neighborState[8];
    }

    @Override
    public void setNeighborState(byte[] neighborState) {
        if (neighborState.length != 9) {
            throw new IllegalArgumentException("Neighbor type does not match.");
        }
        for (int i = 0; i < 9; ++i) {
            this.neighborState[i] = neighborState[i];
        }
    }

    public void setHomeState(byte state) {
        this.neighborState[0] = state;
    }

    public void setNorthState(byte state) {
        this.neighborState[1] = state;
    }

    public void setEastState(byte state) {
        this.neighborState[3] = state;
    }

    public void setSouthState(byte state) {
        this.neighborState[4] = state;
    }

    public void setWestState(byte state) {
        this.neighborState[2] = state;
    }

    public void setNeState(byte state) {
        this.neighborState[5] = state;
    }

    public void setEsState(byte state) {
        this.neighborState[6] = state;
    }

    public void setSwState(byte state) {
        this.neighborState[7] = state;
    }

    public void setWnState(byte state) {
        this.neighborState[8] = state;
    }

    @Override
    public int getMaxNeighbor() {
        return 9;
    }

    private void clear() {
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            this.neighborState[i] = 0;
        }
    }

    public void relocateParticlesAtRandom() {
        int[] allMasses = this.getAllMasses();
        this.clear();
        for (int i = 1; i < allMasses.length; ++i) {
            this.putParticlesAtRandom(i, allMasses[i]);
        }
    }

    private void putParticlesAtRandom(int state, int mass) {
        int remain = mass;
        while (remain > 0) {
            int j = MyMath.irand(9);
            if (this.neighborState[j] != 0) continue;
            this.neighborState[j] = (byte)state;
            --remain;
        }
    }

    public int getXAxis() {
        return this.x;
    }

    public int getYAxis() {
        return this.y;
    }

    public int getOuterTotal() {
        int sum = 0;
        for (int i = 1; i < 9; ++i) {
            sum += this.neighborState[i];
        }
        return sum;
    }

    public int getMass() {
        int mass = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.neighborState[i] == 0) continue;
            ++mass;
        }
        return mass;
    }

    public int getMass(int state) {
        int sum = 0;
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            if (this.neighborState[i] != state) continue;
            ++sum;
        }
        return sum;
    }

    private int[] getAllMasses() {
        int maxState = this.getMaxState();
        int[] allMasses = new int[maxState];
        for (int i = 0; i < maxState; ++i) {
            allMasses[i] = this.getMass(i);
        }
        return allMasses;
    }

    private int getMaxState() {
        byte maxState = 0;
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            if (this.neighborState[i] <= maxState) continue;
            maxState = this.neighborState[i];
        }
        return 9;
    }

    public boolean equals(Block9 ref) {
        if (ref.getHomeState() != this.neighborState[0]) {
            return false;
        }
        if (ref.getEastState() != this.neighborState[3]) {
            return false;
        }
        if (ref.getSouthState() != this.neighborState[4]) {
            return false;
        }
        if (ref.getNorthState() != this.neighborState[1]) {
            return false;
        }
        if (ref.getWestState() != this.neighborState[2]) {
            return false;
        }
        if (ref.getEsState() != this.neighborState[6]) {
            return false;
        }
        if (ref.getNeState() != this.neighborState[5]) {
            return false;
        }
        if (ref.getSwState() != this.neighborState[7]) {
            return false;
        }
        return ref.getWnState() == this.neighborState[8];
    }
}

