/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics;

import Catalano.Math.Matrix;
import Catalano.Statistics.Correlations;
import java.util.Arrays;

public class Tools {
    private Tools() {
    }

    public static double AlphaTrimmedMean(double[] values, float alpha) {
        int lower = (int)((float)values.length * alpha);
        int upper = values.length - lower;
        double sum = 0.0;
        for (int i = lower; i < upper; ++i) {
            sum += values[i];
        }
        return sum / (double)(upper - lower);
    }

    public static double AlphaTrimmedMean(double[] values, int n) {
        int upper = values.length - n;
        double sum = 0.0;
        for (int i = n; i < upper; ++i) {
            sum += values[i];
        }
        return sum / (double)(upper - n);
    }

    public static double AlphaTrimmedMean(int[] values, float alpha) {
        int lower = (int)((float)values.length * alpha);
        int upper = values.length - lower;
        double sum = 0.0;
        for (int i = lower; i < upper; ++i) {
            sum += (double)values[i];
        }
        return sum / (double)(upper - lower);
    }

    public static double AlphaTrimmedMean(int[] values, int n) {
        int upper = values.length - n;
        double sum = 0.0;
        for (int i = n; i < upper; ++i) {
            sum += (double)values[i];
        }
        return sum / (double)(upper - n);
    }

    public static double CoefficientOfVariation(double[] x) {
        double mean = Tools.Mean(x);
        double std = Math.sqrt(Tools.Variance(x, mean));
        return std / mean;
    }

    public static double[][] Correlation(double[][] data) {
        double[][] co = new double[data[0].length][data[0].length];
        for (int i = 0; i < co.length; ++i) {
            for (int j = 0; j < co[0].length; ++j) {
                if (i == j) {
                    co[i][j] = 1.0;
                    continue;
                }
                double[] colX = Matrix.getColumn(data, i);
                double[] colY = Matrix.getColumn(data, j);
                co[i][j] = Correlations.PearsonCorrelation(colX, colY);
            }
        }
        return co;
    }

    public static double Covariance(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The size of both matrix needs be equal");
        }
        double meanX = 0.0;
        double meanY = 0.0;
        for (int i = 0; i < x.length; ++i) {
            meanX += x[i];
            meanY += y[i];
        }
        return Tools.Covariance(x, y, meanX /= (double)x.length, meanY /= (double)y.length);
    }

    public static double Covariance(double[] x, double[] y, double meanX, double meanY) {
        double result = 0.0;
        for (int i = 0; i < x.length; ++i) {
            result += (x[i] - meanX) * (y[i] - meanY);
        }
        return result / (double)(x.length - 1);
    }

    public static double[][] Covariance(double[][] matrix) {
        int i;
        double[] means = new double[matrix[0].length];
        for (i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                int n = j;
                means[n] = means[n] + matrix[i][j];
            }
        }
        i = 0;
        while (i < means.length) {
            int n = i++;
            means[n] = means[n] / (double)means.length;
        }
        return Tools.Covariance(matrix, means);
    }

    public static double[][] Covariance(double[][] matrix, double[] means) {
        double[][] cov = new double[means.length][means.length];
        for (int i = 0; i < cov.length; ++i) {
            for (int j = 0; j < cov[0].length; ++j) {
                cov[i][j] = Tools.Covariance(Matrix.getColumn(matrix, i), Matrix.getColumn(matrix, j), means[i], means[j]);
            }
        }
        return cov;
    }

    public static double Fisher(double n) {
        if (n <= -1.0 || n >= 1.0) {
            throw new IllegalArgumentException("Fisher works with number between -1 < x < 1");
        }
        double r = (1.0 + n) / (1.0 - n);
        return 0.5 * Math.log(r);
    }

    public static double Inclination(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The size of both matrix needs be equal");
        }
        double meanX = 0.0;
        double meanY = 0.0;
        for (int i = 0; i < x.length; ++i) {
            meanX += x[i];
            meanY += y[i];
        }
        meanX /= (double)x.length;
        meanY /= (double)y.length;
        double num = 0.0;
        double den = 0.0;
        for (int i = 0; i < x.length; ++i) {
            num += (x[i] - meanX) * (y[i] - meanY);
            den += Math.pow(x[i] - meanX, 2.0);
        }
        return num / den;
    }

    public static double InverseFisher(double n) {
        if (n <= -1.0 || n >= 1.0) {
            throw new IllegalArgumentException("Fisher works with number between -1 < x < 1");
        }
        double r = (Math.pow(Math.E, 2.0 * n) - 1.0) / (Math.pow(Math.E, 2.0 * n) + 1.0);
        return r;
    }

    public static double Interception(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The size of both matrix needs be equal");
        }
        double meanX = 0.0;
        double meanY = 0.0;
        for (int i = 0; i < x.length; ++i) {
            meanX += x[i];
            meanY += y[i];
        }
        double b = Tools.Inclination(x, y);
        double a = (meanY /= (double)y.length) - b * (meanX /= (double)x.length);
        return a;
    }

    public static double Max(double[] x) {
        double m = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] > m)) continue;
            m = x[i];
        }
        return m;
    }

    public static double Mean(double[] x) {
        double r = 0.0;
        for (int i = 0; i < x.length; ++i) {
            r += x[i];
        }
        return r / (double)x.length;
    }

    public static double[] Mean(double[][] data) {
        int i;
        double[] means = new double[data[0].length];
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                int n = j;
                means[n] = means[n] + data[i][j];
            }
        }
        i = 0;
        while (i < means.length) {
            int n = i++;
            means[n] = means[n] / (double)data.length;
        }
        return means;
    }

    public static double Min(double[] x) {
        double m = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] < m)) continue;
            m = x[i];
        }
        return m;
    }

    public static double Mode(double[] values) {
        Arrays.sort(values);
        double v = values[0];
        int index = 0;
        int x = 0;
        int rep = 0;
        for (int i = 1; i < values.length; ++i) {
            if (values[i] == v) {
                if (++x > rep) {
                    rep = x;
                    index = i;
                }
                v = values[i];
                x = 0;
                continue;
            }
            if (x > rep) {
                rep = x;
                index = i;
            }
            v = values[i];
            x = 0;
        }
        return values[index];
    }

    public static int Mode(int[] values) {
        Arrays.sort(values);
        int v = values[0];
        int index = 0;
        int x = 0;
        int rep = 0;
        for (int i = 1; i < values.length; ++i) {
            if (values[i] == v) {
                if (++x > rep) {
                    rep = x;
                    index = i;
                }
                v = values[i];
                x = 0;
                continue;
            }
            if (x > rep) {
                rep = x;
                index = i;
            }
            v = values[i];
            x = 0;
        }
        return values[index];
    }

    public static double GeometricMean(double[] x) {
        double r = 1.0;
        for (int i = 0; i < x.length; ++i) {
            r *= x[i];
        }
        return Math.pow(r, 1.0 / (double)x.length);
    }

    public static double HarmonicMean(double[] x) {
        double r = 0.0;
        for (int i = 0; i < x.length; ++i) {
            r += 1.0 / x[i];
        }
        return (double)x.length / r;
    }

    public static double ContraHarmonicMean(double[] x, int order) {
        double r1 = 0.0;
        double r2 = 0.0;
        for (int i = 0; i < x.length; ++i) {
            r1 += Math.pow(x[i], order + 1);
            r2 += Math.pow(x[i], order);
        }
        return r1 / r2;
    }

    public static double Sum(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i];
        }
        return sum;
    }

    public static double Variance(double[] x) {
        return Tools.Variance(x, Tools.Mean(x));
    }

    public static double Variance(double[] x, double mean) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.pow(x[i] - mean, 2.0);
        }
        double var = sum / ((double)x.length - 1.0);
        return var;
    }

    public static double StandartDeviation(double[] x) {
        return Math.sqrt(Tools.Variance(x));
    }

    public static double StandartDeviation(double[] x, double mean) {
        return Math.sqrt(Tools.Variance(x, mean));
    }

    public static double[] StandartDeviation(double[][] data) {
        double[] means = Tools.Mean(data);
        return Tools.StandartDeviation(data, means);
    }

    public static double[] StandartDeviation(double[][] data, double[] means) {
        int i;
        double[] std = new double[means.length];
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                int n = j;
                std[n] = std[n] + Math.pow(data[i][j] - means[j], 2.0);
            }
        }
        for (i = 0; i < std.length; ++i) {
            std[i] = Math.sqrt(std[i] / ((double)data.length - 1.0));
        }
        return std;
    }
}

