/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Regression;

import Catalano.Math.Matrix;
import java.util.Arrays;

public class PartialLeastSquaresRegression {
    private double tolerance;
    private int factors;
    private double[][] P;
    private double[][] Q;
    private double[][] T;
    private double[][] U;
    private double[][] W;
    private double[][] coeff;
    private double[] B;

    public double[][] getScoreMatrixX() {
        return this.T;
    }

    public double[][] getScoreMatrixY() {
        return this.U;
    }

    public double[][] getLoadingMatrixX() {
        return this.P;
    }

    public double[][] getLoadingMatrixY() {
        return this.Q;
    }

    public double[][] getW() {
        return this.W;
    }

    public double[] getB() {
        return this.B;
    }

    public double[][] getCoefficients() {
        return this.coeff;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public PartialLeastSquaresRegression(int factors) {
        this(factors, 1.0E-14);
    }

    public PartialLeastSquaresRegression(int factors, double tolerance) {
        this.tolerance = tolerance;
    }

    public void Compute(double[][] X, double[][] Y) {
        int rows = X.length;
        int xcols = X[0].length;
        int ycols = Y[0].length;
        double[][] E = Matrix.Copy(X);
        double[][] F = Matrix.Copy(Y);
        this.T = new double[rows][this.factors];
        this.U = new double[rows][this.factors];
        this.P = new double[xcols][this.factors];
        this.Q = new double[ycols][this.factors];
        this.W = new double[xcols][this.factors];
        this.B = new double[this.factors];
        double[] varX = new double[this.factors];
        double[] varY = new double[this.factors];
        for (int factor = 0; factor < this.factors; ++factor) {
            int i;
            int j;
            double[] t = Matrix.getColumn(E, this.largest(E));
            double[] u = Matrix.getColumn(F, this.largest(F));
            double[] w = new double[xcols];
            double[] c = new double[ycols];
            double norm_t = this.Euclidean(t);
            while (norm_t > this.tolerance) {
                int i2;
                int i3;
                double[] t0 = Arrays.copyOf(t, t.length);
                w = new double[xcols];
                for (int j2 = 0; j2 < w.length; ++j2) {
                    for (int i4 = 0; i4 < u.length; ++i4) {
                        w[j2] = w[j2] + E[i4][j2] * u[i4];
                    }
                }
                double Ew = this.Euclidean(w);
                for (i3 = 0; i3 < w.length; ++i3) {
                    w[i3] = w[i3] / Ew;
                }
                t = new double[rows];
                for (i3 = 0; i3 < t.length; ++i3) {
                    for (j = 0; j < w.length; ++j) {
                        t[i3] = t[i3] + E[i3][j] * w[j];
                    }
                }
                double Et = this.Euclidean(t);
                for (int i5 = 0; i5 < t.length; ++i5) {
                    t[i5] = t[i5] / Et;
                }
                c = new double[ycols];
                for (int j3 = 0; j3 < c.length; ++j3) {
                    for (int i6 = 0; i6 < t.length; ++i6) {
                        c[j3] = c[j3] + F[i6][j3] * t[i6];
                    }
                }
                double Ec = this.Euclidean(c);
                for (i2 = 0; i2 < c.length; ++i2) {
                    c[i2] = c[i2] / Ec;
                }
                u = new double[rows];
                for (i2 = 0; i2 < u.length; ++i2) {
                    for (int j4 = 0; j4 < c.length; ++j4) {
                        u[i2] = u[i2] + F[i2][j4] * c[j4];
                    }
                }
                norm_t = 0.0;
                for (i2 = 0; i2 < t.length; ++i2) {
                    double d = t0[i2] - t[i2];
                    norm_t += d * d;
                }
                norm_t = Math.sqrt(norm_t);
            }
            double b = 0.0;
            for (int i7 = 0; i7 < t.length; ++i7) {
                b += t[i7] * u[i7];
            }
            double[] p = new double[xcols];
            for (int j5 = 0; j5 < p.length; ++j5) {
                for (int i8 = 0; i8 < rows; ++i8) {
                    p[j5] = p[j5] + E[i8][j5] * t[i8];
                }
            }
            for (int i9 = 0; i9 < t.length; ++i9) {
                for (j = 0; j < p.length; ++j) {
                    E[i9][j] = E[i9][j] - t[i9] * p[j];
                }
                for (j = 0; j < c.length; ++j) {
                    F[i9][j] = F[i9][j] - b * t[i9] * c[j];
                }
            }
            varY[factor] = b * b;
            double temp = 0.0;
            for (i = 0; i < p.length; ++i) {
                temp += p[i] * p[i];
            }
            varX[factor] = temp;
            for (i = 0; i < t.length; ++i) {
                this.T[i][factor] = t[i];
            }
            for (i = 0; i < p.length; ++i) {
                this.P[i][factor] = p[i];
            }
            for (i = 0; i < u.length; ++i) {
                this.U[i][factor] = u[i];
            }
            for (i = 0; i < c.length; ++i) {
                this.Q[i][factor] = c[i];
            }
            for (i = 0; i < w.length; ++i) {
                this.W[i][factor] = w[i];
            }
            this.B[factor] = b;
        }
        double[][] temp = new double[this.B.length][this.B.length];
        for (int i = 0; i < this.B.length; ++i) {
            temp[i][i] = this.B[i];
        }
        double[][] mat = Matrix.PseudoInverse(Matrix.Transpose(this.P));
        mat = Matrix.Multiply(mat, temp);
        mat = Matrix.Multiply(mat, Matrix.Transpose(this.Q));
        this.coeff = mat;
    }

    private double Euclidean(double[] v) {
        double r = 0.0;
        for (int i = 0; i < v.length; ++i) {
            r += Math.pow(v[i], 2.0);
        }
        return Math.sqrt(r);
    }

    private int largest(double[][] matrix) {
        int index = 0;
        double max = 0.0;
        for (int i = 0; i < matrix[0].length; ++i) {
            double sum = 0.0;
            for (int j = 0; j < matrix.length; ++j) {
                sum += matrix[j][i] * matrix[j][i];
            }
            if (!(sum > max)) continue;
            max = sum;
            index = i;
        }
        return index;
    }
}

