/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics;

import Catalano.Statistics.DescriptiveStatistics;

public class Normalizations {
    private Normalizations() {
    }

    public static double[] DecimalScaling(double[] data) {
        double max = 0.0;
        for (int i = 0; i < data.length; ++i) {
            max = Math.abs(data[i]);
        }
        int k = 10;
        while (max / (double)k > 1.0) {
            k *= 10;
        }
        double[] result = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = data[i] / (double)k;
        }
        return result;
    }

    public static double[] RangeNormalization(double[] data, double fromMin, double fromMax, double toMin, double toMax) {
        double[] norm = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            norm[i] = (toMax - toMin) * (norm[i] - fromMin) / (fromMax - fromMin) + toMin;
            if (fromMax - fromMin != 0.0) continue;
            norm[i] = 0.0;
        }
        return norm;
    }

    public static double[] UnitVectorNormalization(double[] data) {
        int i;
        double[] norm = new double[data.length];
        double magnitude = 0.0;
        for (i = 0; i < data.length; ++i) {
            magnitude += data[i] * data[i];
        }
        magnitude = Math.sqrt(magnitude);
        for (i = 0; i < data.length; ++i) {
            norm[i] = data[i] / magnitude;
        }
        return norm;
    }

    public static double[] StandartNormalDensity(double[] data) {
        double[] norm = new double[data.length];
        double mean = DescriptiveStatistics.Mean(data);
        double stdDev = DescriptiveStatistics.StandartDeviation(data);
        for (int i = 0; i < data.length; ++i) {
            norm[i] = (data[i] - mean) / stdDev;
        }
        return norm;
    }

    public static double[] MinMaxNormalization(double[] data, double min, double max) {
        double[] norm = new double[data.length];
        double fMin = DescriptiveStatistics.Minimum(data);
        double fMax = DescriptiveStatistics.Maximum(data);
        for (int i = 0; i < data.length; ++i) {
            norm[i] = (data[i] - fMin) / (fMax - fMin) * (max - min) + min;
        }
        return norm;
    }

    public static double[] SoftmaxScaling(double[] data, double r) {
        double[] norm = new double[data.length];
        double mean = DescriptiveStatistics.Mean(data);
        double stdDev = DescriptiveStatistics.StandartDeviation(data);
        r *= stdDev;
        for (int i = 0; i < data.length; ++i) {
            double y = (data[i] - mean) / r;
            norm[i] = 1.0 / (1.0 + Math.pow(Math.E, -y));
        }
        return norm;
    }
}

