/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Kernels;

import Catalano.Statistics.Kernels.IMercerKernel;

public class Wave
implements IMercerKernel<double[]> {
    private double sigma;

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public Wave(double sigma) {
        this.sigma = sigma;
    }

    @Override
    public double Function(double[] x, double[] y) {
        double norm = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double d = x[i] - y[i];
            norm += d * d;
        }
        norm = Math.sqrt(norm);
        if (this.sigma == 0.0 || norm == 0.0) {
            return 0.0;
        }
        return this.sigma / norm * Math.sin(norm / this.sigma);
    }
}

