/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Kernels;

import Catalano.Statistics.Kernels.IMercerKernel;

public class ThinPlateSpline
implements IMercerKernel<double[]> {
    private double sigma = 1.0;

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = Math.max(1.0, sigma);
    }

    public ThinPlateSpline() {
    }

    public ThinPlateSpline(double sigma) {
        this.setSigma(sigma);
    }

    @Override
    public double Function(double[] x, double[] y) {
        double r = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double dxy = x[i] - y[i];
            r += dxy * dxy;
        }
        return r / (this.sigma * this.sigma) * Math.log(Math.sqrt(r) / this.sigma);
    }
}

