/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Kernels;

import Catalano.Statistics.Kernels.IMercerKernel;

public class Polynomial
implements IMercerKernel<double[]> {
    private int degree;
    private double constant;

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = Math.max(1, degree);
    }

    public double getConstant() {
        return this.constant;
    }

    public void setConstant(double constant) {
        this.constant = constant;
    }

    public Polynomial() {
        this(2);
    }

    public Polynomial(int degree) {
        this(degree, 1.0);
    }

    public Polynomial(int degree, double constant) {
        this.setDegree(degree);
        this.constant = constant;
    }

    @Override
    public double Function(double[] x, double[] y) {
        double sum = this.constant;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * y[i];
        }
        return Math.pow(sum, this.degree);
    }
}

