/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Kernels;

import Catalano.Statistics.Kernels.IMercerKernel;

public class Pearson
implements IMercerKernel<double[]> {
    private double omega;
    private double sigma;
    private double constant;

    public double getOmega() {
        return this.omega;
    }

    public void setOmega(double omega) {
        this.omega = omega;
        this.constant = 2.0 * Math.sqrt(Math.pow(2.0, 1.0 / omega) - 1.0) / this.sigma;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
        this.constant = 2.0 * Math.sqrt(Math.pow(2.0, 1.0 / this.omega) - 1.0) / sigma;
    }

    public Pearson() {
        this(1.0, 1.0);
    }

    public Pearson(double omega, double sigma) {
        this.setOmega(omega);
        this.setSigma(sigma);
    }

    @Override
    public double Function(double[] x, double[] y) {
        double xx = 0.0;
        double yy = 0.0;
        double xy = 0.0;
        for (int i = 0; i < x.length; ++i) {
            xx += x[i] * x[i];
            yy += y[i] * y[i];
            xy += x[i] * y[i];
        }
        double m = this.constant * Math.sqrt(-2.0 * xy + xx + yy);
        return 1.0 / Math.pow(1.0 + m * m, this.omega);
    }
}

