/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Kernels;

import Catalano.Statistics.Kernels.IMercerKernel;

public class Circular
implements IMercerKernel<double[]> {
    private final double c2dPI = 0.6366197723675814;
    private double sigma;

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public Circular(double sigma) {
        this.sigma = sigma;
    }

    @Override
    public double Function(double[] x, double[] y) {
        double norm = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double d = x[i] - y[i];
            norm += d * d;
        }
        if ((norm = Math.sqrt(norm)) >= this.sigma) {
            return 0.0;
        }
        double a = 0.6366197723675814 * Math.acos(-(norm /= this.sigma));
        double b = 0.6366197723675814 * norm;
        double c = 1.0 - norm * norm;
        return a - b * Math.sqrt(c);
    }
}

