/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Kernels;

import Catalano.Statistics.Kernels.IMercerKernel;

public class Cauchy
implements IMercerKernel<double[]> {
    private double sigma;

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public Cauchy() {
        this.sigma = 1.0;
    }

    public Cauchy(double sigma) {
        this.sigma = sigma;
    }

    @Override
    public double Function(double[] x, double[] y) {
        if (x == y) {
            return 1.0;
        }
        double norm = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double d = x[i] - y[i];
            norm += d * d;
        }
        return 1.0 / (1.0 + norm / this.sigma);
    }
}

