/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Kernels;

import Catalano.Statistics.Kernels.IMercerKernel;

public class Bessel
implements IMercerKernel<double[]> {
    private int order;
    private double sigma;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public Bessel(int order, double sigma) {
        this.order = order;
        this.sigma = sigma;
    }

    @Override
    public double Function(double[] x, double[] y) {
        double norm = 0.0;
        for (int k = 0; k < x.length; ++k) {
            double d = x[k] - y[k];
            norm += d * d;
        }
        norm = Math.sqrt(norm);
        return Catalano.Math.Functions.Bessel.J(this.order, this.sigma * norm) / Math.pow(norm, -norm * (double)this.order);
    }
}

