/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Statistics.Distributions.IDistribution;

public class ParetoDistribution
implements IDistribution {
    private double xm;
    private double a;

    public ParetoDistribution(double scale, double shape) {
        this.xm = scale;
        this.a = shape;
    }

    @Override
    public double Mean() {
        return this.a * this.xm / (this.a - 1.0);
    }

    @Override
    public double Variance() {
        return this.xm * this.xm * this.a / ((this.a - 1.0) * (this.a - 1.0) * (this.a - 2.0));
    }

    @Override
    public double Entropy() {
        return Math.log(this.xm / this.a) + 1.0 / this.a + 1.0;
    }

    public double Mode() {
        return this.xm;
    }

    public double Median() {
        return this.xm * Math.pow(2.0, 1.0 / this.a);
    }

    @Override
    public double DistributionFunction(double x) {
        if (x >= this.xm) {
            return 1.0 - Math.pow(this.xm / x, this.a);
        }
        return 0.0;
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        if (x >= this.xm) {
            return this.a * Math.pow(this.xm, this.a) / Math.pow(x, this.a + 1.0);
        }
        return 0.0;
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        if (x >= this.xm) {
            return Math.log(this.a) + this.a * Math.log(this.xm) - (this.a + 1.0) * Math.log(x);
        }
        return 0.0;
    }
}

