/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Math.Functions.Normal;
import Catalano.Math.Special;
import Catalano.Statistics.Distributions.IDistribution;

public class NormalDistribution
implements IDistribution {
    private double mean = 0.0;
    private double stdDev = 1.0;
    private Double entropy;
    private double variance = 1.0;
    private double lnconstant;
    private final double p95 = 1.9599639845400543;

    public NormalDistribution() {
        this.init(this.mean, this.stdDev, this.stdDev * this.stdDev);
    }

    public NormalDistribution(double mean) {
        this.init(mean, this.stdDev, this.stdDev * this.stdDev);
    }

    public NormalDistribution(double mean, double stdDev) {
        if (stdDev <= 0.0) {
            try {
                throw new IllegalArgumentException("Standard deviation must be positive.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.init(mean, stdDev, stdDev * stdDev);
    }

    private void init(double mu, double dev, double var) {
        this.mean = mu;
        this.stdDev = dev;
        this.variance = var;
        this.lnconstant = -Math.log(2.5066282746310007 * dev);
    }

    @Override
    public double Mean() {
        return this.mean;
    }

    @Override
    public double Variance() {
        return this.variance;
    }

    public double StandartDeviation() {
        return this.stdDev;
    }

    @Override
    public double Entropy() {
        if (this.entropy == null) {
            this.entropy = 0.5 * (Math.log(Math.PI * 2 * this.variance) + 1.0);
        }
        return this.entropy;
    }

    @Override
    public double DistributionFunction(double x) {
        double z = (x - this.mean) / this.stdDev;
        return Special.Erfc(-z / 1.4142135623730951) * 0.5;
    }

    public double InverseDistributionFunction(double p) {
        return this.mean + this.stdDev * Normal.Inverse(p);
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        double z = (x - this.mean) / this.stdDev;
        double lnp = this.lnconstant - z * z * 0.5;
        return Math.exp(lnp);
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        double z = (x - this.mean) / this.stdDev;
        double lnp = this.lnconstant - z * z * 0.5;
        return lnp;
    }

    public double ZScore(double x) {
        return (x - this.mean) / this.stdDev;
    }
}

