/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Statistics.Distributions.IDistribution;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LaplaceDistribution
implements IDistribution {
    private double u;
    private double b;
    private double constant;

    public LaplaceDistribution(double location, double scale) {
        if (scale <= 0.0) {
            try {
                throw new Exception("Scale must be non-negative.");
            }
            catch (Exception ex) {
                Logger.getLogger(LaplaceDistribution.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.u = location;
        this.b = scale;
        this.constant = 1.0 / (2.0 * this.b);
    }

    @Override
    public double Mean() {
        return this.u;
    }

    @Override
    public double Variance() {
        return 2.0 * this.b * this.b;
    }

    @Override
    public double Entropy() {
        return Math.log(5.43656365691809 * this.b);
    }

    @Override
    public double DistributionFunction(double x) {
        return 0.5 * (1.0 + Math.signum(x - this.u) * (1.0 - Math.exp(-Math.abs(x - this.u) / this.b)));
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        return this.constant * Math.exp(-Math.abs(x - this.u) / this.b);
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        return Math.log(this.constant) - Math.abs(x - this.u) / this.b;
    }
}

