/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Statistics.Distributions.IDistribution;

public class ExponentialDistribution
implements IDistribution {
    private double lambda;
    private double lnlambda;

    public ExponentialDistribution(double rate) {
        this.lambda = rate;
        this.lnlambda = Math.log(rate);
    }

    @Override
    public double Mean() {
        return 1.0 / this.lambda;
    }

    @Override
    public double Variance() {
        return 1.0 / (this.lambda * this.lambda);
    }

    public double Median() {
        return Math.log(2.0) / this.lambda;
    }

    public double Mode() {
        return 0.0;
    }

    @Override
    public double Entropy() {
        return 1.0 - Math.log(this.lambda);
    }

    @Override
    public double DistributionFunction(double x) {
        return 1.0 - Math.exp(-this.lambda * x);
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        return this.lambda * Math.exp(-this.lambda * x);
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        return this.lnlambda - this.lambda * x;
    }
}

