/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Statistics.Distributions.IDistribution;

public class ContinuousUniformDistribution
implements IDistribution {
    private double a;
    private double b;

    public ContinuousUniformDistribution() {
        this(0.0, 1.0);
    }

    public ContinuousUniformDistribution(double a, double b) {
        if (a > b) {
            try {
                throw new IllegalArgumentException("The starting number a must be lower than b.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.a = a;
        this.b = b;
    }

    public double Length() {
        return this.b - this.a;
    }

    @Override
    public double Mean() {
        return (this.a + this.b) / 2.0;
    }

    public double Minimum() {
        return this.a;
    }

    public double Maximum() {
        return this.b;
    }

    @Override
    public double Variance() {
        return (this.b - this.a) * (this.b - this.a) / 12.0;
    }

    @Override
    public double Entropy() {
        return Math.log(this.b - this.a);
    }

    @Override
    public double DistributionFunction(double x) {
        if (x < this.a) {
            return 0.0;
        }
        if (x >= this.b) {
            return 1.0;
        }
        return (x - this.a) / (this.b - this.a);
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        if (x >= this.a && x <= this.b) {
            return 1.0 / (this.b - this.a);
        }
        return 0.0;
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        if (x >= this.a && x <= this.b) {
            return -Math.log(this.b - this.a);
        }
        return Double.NEGATIVE_INFINITY;
    }
}

