/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics;

import Catalano.Core.ArraysUtil;

public final class DescriptiveStatistics {
    private DescriptiveStatistics() {
    }

    public static double Mean(double[] values) {
        double mean = 0.0;
        for (int i = 0; i < values.length; ++i) {
            mean += values[i];
        }
        return mean / (double)values.length;
    }

    public static float Mean(float[] values) {
        float mean = 0.0f;
        for (int i = 0; i < values.length; ++i) {
            mean += values[i];
        }
        return mean / (float)values.length;
    }

    public static double Mean(int[] values) {
        double mean = 0.0;
        for (int i = 0; i < values.length; ++i) {
            mean += (double)values[i];
        }
        return mean / (double)values.length;
    }

    public static double Median(double[] values) {
        if (values.length == 1) {
            return values[0];
        }
        int[] index = ArraysUtil.Argsort(values, true);
        return values[index[(values.length + 1) / 2]];
    }

    public static double Mode(double[] values) {
        int[] ord = ArraysUtil.Argsort(values, true);
        double v = values[ord[0]];
        int index = 0;
        int x = 0;
        int rep = 0;
        for (int i = 1; i < values.length; ++i) {
            if (values[ord[i]] == v) {
                if (++x > rep) {
                    rep = x;
                    index = i;
                }
                v = values[ord[i]];
                x = 0;
                continue;
            }
            if (x > rep) {
                rep = x;
                index = i;
            }
            v = values[ord[i]];
            x = 0;
        }
        return values[index];
    }

    public static double Minimum(double[] values) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (!(min > values[i])) continue;
            min = values[i];
        }
        return min;
    }

    public static double Maximum(double[] values) {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (!(max < values[i])) continue;
            max = values[i];
        }
        return max;
    }

    public static double Variance(double[] values, double mean) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += Math.pow(values[i] - mean, 2.0);
        }
        return sum / ((double)values.length - 1.0);
    }

    public static float Variance(float[] values, float mean) {
        float sum = 0.0f;
        for (int i = 0; i < values.length; ++i) {
            sum = (float)((double)sum + Math.pow(values[i] - mean, 2.0));
        }
        return sum / ((float)values.length - 1.0f);
    }

    public static double Variance(double[] values) {
        double mean = DescriptiveStatistics.Mean(values);
        return DescriptiveStatistics.Variance(values, mean);
    }

    public static float Variance(float[] values) {
        float mean = DescriptiveStatistics.Mean(values);
        return DescriptiveStatistics.Variance(values, mean);
    }

    public static double Range(double[] values) {
        double min = values[0];
        double max = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
            max = Math.max(max, values[i]);
        }
        return max - min;
    }

    public static double StandartDeviation(double[] values) {
        double var = DescriptiveStatistics.Variance(values);
        return Math.sqrt(var);
    }

    public static double StandartDeviation(double[] values, double mean) {
        double var = DescriptiveStatistics.Variance(values, mean);
        return Math.sqrt(var);
    }

    public static double Kurtosis(double[] values, double mean, double stdDeviation) {
        double n = values.length;
        double part1 = n * (n + 1.0);
        part1 /= (n - 1.0) * (n - 2.0) * (n - 3.0);
        double part2 = 0.0;
        for (int i = 0; i < values.length; ++i) {
            part2 += Math.pow((values[i] - mean) / stdDeviation, 4.0);
        }
        double part3 = 3.0 * Math.pow(n - 1.0, 2.0);
        return part1 * part2 - (part3 /= (n - 2.0) * (n - 3.0));
    }

    public static double Kurtosis(double[] values) {
        double mean = DescriptiveStatistics.Mean(values);
        double std = DescriptiveStatistics.StandartDeviation(values, mean);
        return DescriptiveStatistics.Kurtosis(values, mean, std);
    }

    public static double Skewness(double[] values, double mean, double stdDeviation) {
        double n = values.length;
        double part1 = n / ((n - 1.0) * (n - 2.0));
        double part2 = 0.0;
        for (int i = 0; i < values.length; ++i) {
            part2 += Math.pow((values[i] - mean) / stdDeviation, 3.0);
        }
        return part1 * part2;
    }

    public static double Skewness(double[] values) {
        double mean = DescriptiveStatistics.Mean(values);
        double std = DescriptiveStatistics.StandartDeviation(values, mean);
        return DescriptiveStatistics.Skewness(values, mean, std);
    }
}

