/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Neuro.ActivationFunction;

import Catalano.Neuro.ActivationFunction.IActivationFunction;

public class LeakyReluFunction
implements IActivationFunction {
    private double alpha;

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public LeakyReluFunction() {
        this(0.01);
    }

    public LeakyReluFunction(double alpha) {
        this.setAlpha(alpha);
    }

    @Override
    public double Function(double x) {
        if (x < 0.0) {
            return this.alpha * x;
        }
        return x;
    }

    @Override
    public double Derivative(double x) {
        if (x < 0.0) {
            return this.alpha;
        }
        return 1.0;
    }

    @Override
    public double Derivative2(double x) {
        return this.Derivative(x);
    }
}

