/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Neuro.ActivationFunction;

import Catalano.Neuro.ActivationFunction.IActivationFunction;

public class ExponentialLinearFunction
implements IActivationFunction {
    private double alpha;

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public ExponentialLinearFunction() {
        this(1.0);
    }

    public ExponentialLinearFunction(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public double Function(double x) {
        if (x < 0.0) {
            return this.alpha * (Math.exp(x) - 1.0);
        }
        return x;
    }

    @Override
    public double Derivative(double x) {
        if (x < 0.0) {
            return this.Function(x) + this.alpha;
        }
        return 1.0;
    }

    @Override
    public double Derivative2(double x) {
        if (x < 0.0) {
            return x + this.alpha;
        }
        return 1.0;
    }
}

