/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math;

import Catalano.Math.Vector3;

public class Vector4 {
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4() {
    }

    public Vector4(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4(float value) {
        this.z = this.w = value;
        this.y = this.w;
        this.x = this.w;
    }

    public float getMax() {
        float v1 = this.x > this.y ? this.x : this.y;
        float v2 = this.z > this.w ? this.z : this.w;
        return v1 > v2 ? v1 : v2;
    }

    public float getMin() {
        float v1 = this.x < this.y ? this.x : this.y;
        float v2 = this.z < this.w ? this.z : this.w;
        return v1 < v2 ? v1 : v2;
    }

    public int getMaxIndex() {
        float v1 = 0.0f;
        float v2 = 0.0f;
        int i1 = 0;
        int i2 = 0;
        if (this.x >= this.y) {
            v1 = this.x;
            i1 = 0;
        } else {
            v1 = this.y;
            i1 = 1;
        }
        if (this.z >= this.w) {
            v2 = this.z;
            i2 = 2;
        } else {
            v2 = this.w;
            i2 = 3;
        }
        return v1 >= v2 ? i1 : i2;
    }

    public int getMinIndex() {
        float v1 = 0.0f;
        float v2 = 0.0f;
        int i1 = 0;
        int i2 = 0;
        if (this.x <= this.y) {
            v1 = this.x;
            i1 = 0;
        } else {
            v1 = this.y;
            i1 = 1;
        }
        if (this.z <= this.w) {
            v2 = this.z;
            i2 = 2;
        } else {
            v2 = this.w;
            i2 = 3;
        }
        return v1 <= v2 ? i1 : i2;
    }

    public float Norm() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public float Square() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public float[] toArray() {
        return new float[]{this.x, this.y, this.z, this.w};
    }

    public static Vector4 Add(Vector4 vector1, Vector4 vector2) {
        return new Vector4(vector1.x + vector2.x, vector1.y + vector2.y, vector1.z + vector2.z, vector1.w + vector2.w);
    }

    public static Vector4 Add(Vector4 vector1, float value) {
        return new Vector4(vector1.x + value, vector1.y + value, vector1.z + value, vector1.w + value);
    }

    public static Vector4 Subtract(Vector4 vector1, Vector4 vector2) {
        return new Vector4(vector1.x - vector2.x, vector1.y - vector2.y, vector1.z - vector2.z, vector1.w - vector2.w);
    }

    public static Vector4 Subtract(Vector4 vector1, float value) {
        return new Vector4(vector1.x - value, vector1.y - value, vector1.z - value, vector1.w - value);
    }

    public static Vector4 Multiply(Vector4 vector1, Vector4 vector2) {
        return new Vector4(vector1.x * vector2.x, vector1.y * vector2.y, vector1.z * vector2.z, vector1.w * vector2.w);
    }

    public static Vector4 Multiply(Vector4 vector, float factor) {
        return new Vector4(vector.x * factor, vector.y * factor, vector.z * factor, vector.w * factor);
    }

    public static Vector4 Divide(Vector4 vector1, Vector4 vector2) {
        return new Vector4(vector1.x / vector2.x, vector1.y / vector2.y, vector1.z / vector2.z, vector1.w / vector2.w);
    }

    public static Vector4 Divide(Vector4 vector, float factor) {
        return new Vector4(vector.x / factor, vector.y / factor, vector.z / factor, vector.w / factor);
    }

    public float Normalize() {
        float norm = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        float invNorm = 1.0f / norm;
        this.x *= invNorm;
        this.y *= invNorm;
        this.z *= invNorm;
        this.w *= invNorm;
        return norm;
    }

    public Vector4 Inverse() {
        return new Vector4(this.x == 0.0f ? 0.0f : 1.0f / this.z, this.y == 0.0f ? 0.0f : 1.0f / this.y, this.y == 0.0f ? 0.0f : 1.0f / this.y, this.w == 0.0f ? 0.0f : 1.0f / this.w);
    }

    public Vector4 Abs() {
        return new Vector4(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z), Math.abs(this.w));
    }

    public static float Dot(Vector4 vector1, Vector4 vector2) {
        return vector1.x * vector2.x + vector1.y * vector2.y + vector1.z * vector2.z + vector1.w * vector2.w;
    }

    public Vector3 toVector3() {
        return new Vector3(this.x / this.w, this.y / this.w, this.z / this.w);
    }

    public boolean equals(Object obj) {
        if (obj.getClass().isAssignableFrom(Vector3.class)) {
            Vector4 v = (Vector4)obj;
            if (this.x == v.x && this.y == v.y && this.z == v.z && this.w == v.w) {
                return true;
            }
        }
        return false;
    }
}

