/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Transforms;

public final class DiscreteHartleyTransform {
    private DiscreteHartleyTransform() {
    }

    public static void Forward(double[] data) {
        double[] result = new double[data.length];
        for (int k = 0; k < result.length; ++k) {
            double sum = 0.0;
            for (int n = 0; n < data.length; ++n) {
                double theta = Math.PI * 2 / (double)data.length * (double)k * (double)n;
                sum += data[n] * DiscreteHartleyTransform.cas(theta);
            }
            result[k] = 1.0 / Math.sqrt(data.length) * sum;
        }
        for (int i = 0; i < result.length; ++i) {
            data[i] = result[i];
        }
    }

    public static void Backward(double[] data) {
        DiscreteHartleyTransform.Forward(data);
    }

    public static void Forward(double[][] data) {
        double[][] result = new double[data.length][data[0].length];
        for (int m = 0; m < data.length; ++m) {
            for (int n = 0; n < data[0].length; ++n) {
                double sum = 0.0;
                for (int i = 0; i < result.length; ++i) {
                    for (int k = 0; k < data.length; ++k) {
                        sum += data[i][k] * DiscreteHartleyTransform.cas(Math.PI * 2 / (double)data.length * (double)(i * m + k * n));
                    }
                    result[m][n] = 1.0 / (double)data.length * sum;
                }
            }
        }
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                data[i][j] = result[i][j];
            }
        }
    }

    public static void Backward(double[][] data) {
        DiscreteHartleyTransform.Forward(data);
    }

    private static double cas(double theta) {
        return 1.4142135623730951 * Math.cos(theta - 0.7853981633974483);
    }
}

