/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math;

import java.math.BigInteger;

public class RationalNumber {
    private BigInteger num;
    private BigInteger den;
    boolean alwaysFactorize = true;

    public BigInteger getNumerator() {
        return this.num;
    }

    public void setNumerator(BigInteger numerator) {
        this.num = numerator;
    }

    public BigInteger getDenominator() {
        return this.den;
    }

    public void setDenominator(BigInteger denominator) {
        this.den = denominator;
    }

    public boolean isAlwaysFactorize() {
        return this.alwaysFactorize;
    }

    public void setAlwaysFactorize(boolean alwaysFactorize) {
        this.alwaysFactorize = alwaysFactorize;
    }

    public RationalNumber(int number) {
        this.num = new BigInteger(String.valueOf(number));
        this.den = new BigInteger("1");
    }

    public RationalNumber(int numerator, int denominator) {
        this(new BigInteger(String.valueOf(numerator)), new BigInteger(String.valueOf(denominator)));
    }

    public RationalNumber(BigInteger number) {
        this.num = number;
        this.den = new BigInteger("1");
    }

    public RationalNumber(BigInteger numerator, BigInteger denominator) {
        this.num = numerator;
        this.den = denominator;
        if (denominator.compareTo(new BigInteger("0")) == 0) {
            throw new IllegalArgumentException("The denominator must be different from zero.");
        }
        if (denominator.compareTo(new BigInteger("0")) < 0) {
            this.num = this.num.multiply(new BigInteger("-1"));
            this.den = this.den.multiply(new BigInteger("-1"));
        }
        if (this.alwaysFactorize) {
            this.Factorize();
        }
    }

    public static RationalNumber Abs(RationalNumber rn) {
        return new RationalNumber(rn.getNumerator().abs(), rn.getDenominator());
    }

    public static RationalNumber Add(RationalNumber rn1, RationalNumber rn2) {
        RationalNumber temp = new RationalNumber(rn1.getNumerator(), rn1.getDenominator());
        temp.Add(rn2);
        return temp;
    }

    public void Abs() {
        this.num = this.num.abs();
    }

    public void Add(int number) {
        this.Add(new RationalNumber(number));
    }

    public void Add(int numerator, int denominator) {
        this.Add(new RationalNumber(numerator, denominator));
    }

    public void Add(BigInteger number) {
        this.Add(new RationalNumber(number));
    }

    public void Add(BigInteger numerator, BigInteger denominator) {
        this.Add(new RationalNumber(numerator, denominator));
    }

    public void Add(RationalNumber rn) {
        BigInteger denFinal = this.den.multiply(rn.getDenominator());
        BigInteger numerator1 = this.num.multiply(rn.getDenominator());
        BigInteger numerator2 = rn.getNumerator().multiply(this.den);
        this.num = numerator1.add(numerator2);
        this.den = denFinal;
        if (this.alwaysFactorize) {
            this.Factorize();
        }
    }

    public static RationalNumber Divide(RationalNumber rn1, RationalNumber rn2) {
        RationalNumber temp = new RationalNumber(rn1.getNumerator(), rn1.getDenominator());
        temp.Divide(rn2);
        return temp;
    }

    public void Divide(int number) {
        this.Divide(new RationalNumber(number));
    }

    public void Divide(int numerator, int denominator) {
        this.Divide(new RationalNumber(numerator, denominator));
    }

    public void Divide(BigInteger number) {
        this.Divide(new RationalNumber(number, new BigInteger("1")));
    }

    public void Divide(BigInteger numerator, BigInteger denominator) {
        this.Divide(new RationalNumber(numerator, denominator));
    }

    public void Divide(RationalNumber rn) {
        this.Multiply(rn.den, rn.num);
    }

    public static RationalNumber Multiply(RationalNumber rn1, RationalNumber rn2) {
        RationalNumber temp = new RationalNumber(rn1.getNumerator(), rn1.getDenominator());
        temp.Multiply(rn2);
        return temp;
    }

    public void Multiply(int number) {
        this.Multiply(new RationalNumber(number));
    }

    public void Multiply(int numerator, int denominator) {
        this.Multiply(new RationalNumber(numerator, denominator));
    }

    public void Multiply(BigInteger number) {
        this.Multiply(new RationalNumber(number));
    }

    public void Multiply(BigInteger numerator, BigInteger denominator) {
        this.Multiply(new RationalNumber(numerator, denominator));
    }

    public void Multiply(RationalNumber rn) {
        this.num = this.num.multiply(rn.num);
        this.den = this.den.multiply(rn.den);
        if (this.den.compareTo(new BigInteger("0")) < 0) {
            this.num = this.num.multiply(new BigInteger("-1"));
            this.den = this.den.multiply(new BigInteger("-1"));
        }
        if (this.alwaysFactorize) {
            this.Factorize();
        }
    }

    public static RationalNumber Pow(RationalNumber rn, int power) {
        RationalNumber r = new RationalNumber(rn.getNumerator(), rn.getDenominator());
        for (int i = 1; i < power; ++i) {
            r = RationalNumber.Multiply(r, rn);
        }
        return r;
    }

    public void pow(int power) {
        RationalNumber rn = new RationalNumber(this.num, this.den);
        for (int i = 1; i < power; ++i) {
            this.num = this.num.multiply(rn.num);
            this.den = this.den.multiply(rn.den);
        }
    }

    public static RationalNumber Subtract(RationalNumber rn1, RationalNumber rn2) {
        RationalNumber temp = new RationalNumber(rn1.getNumerator(), rn1.getDenominator());
        temp.Subtract(rn2);
        return temp;
    }

    public void Subtract(int number) {
        this.Subtract(new RationalNumber(number));
    }

    public void Subtract(int numerator, int denominator) {
        this.Subtract(new RationalNumber(numerator, denominator));
    }

    public void Subtract(BigInteger number) {
        this.Subtract(new RationalNumber(number));
    }

    public void Subtract(BigInteger numerator, BigInteger denominator) {
        this.Subtract(new RationalNumber(numerator, denominator));
    }

    public void Subtract(RationalNumber rn) {
        BigInteger denFinal = this.den.multiply(rn.getDenominator());
        BigInteger numerator1 = this.num.multiply(rn.getDenominator());
        BigInteger numerator2 = rn.getNumerator().multiply(this.den);
        this.num = numerator1.subtract(numerator2);
        this.den = denFinal;
        if (this.alwaysFactorize) {
            this.Factorize();
        }
    }

    public void Factorize() {
        BigInteger gcd = this.num.gcd(this.den);
        this.num = this.num.divide(gcd);
        this.den = this.den.divide(gcd);
    }

    public void Swap() {
        BigInteger x = this.num;
        this.num = this.den;
        this.den = x;
    }

    public double doubleValue() {
        return this.num.doubleValue() / this.den.doubleValue();
    }

    public String toString() {
        return this.num.toString() + " / " + this.den.toString();
    }
}

