/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math;

import Catalano.Math.Matrix;

public class PaddingMatrix {
    private int rows;
    private int cols;
    private double value;
    private boolean replicate;

    public PaddingMatrix(int rows, int cols) {
        this(rows, cols, 0.0);
    }

    public PaddingMatrix(int rows, int cols, double value) {
        this.rows = rows;
        this.cols = cols;
        this.value = value;
    }

    public PaddingMatrix(int rows, int cols, boolean replicate) {
        this.rows = rows;
        this.cols = cols;
        this.replicate = replicate;
    }

    public double[][] Create(double[][] matrix) {
        if (this.replicate) {
            double[][] result = Matrix.CreateMatrix2D(matrix.length + 2 * this.rows, matrix[0].length + 2 * this.cols, this.value);
            for (int i = 0; i < result.length; ++i) {
                int r = i - this.rows;
                for (int j = 0; j < result[0].length; ++j) {
                    int c = j - this.cols;
                    if (r >= 0 && r < matrix.length && c >= 0 && c < matrix[0].length) {
                        result[i][j] = matrix[r][c];
                        continue;
                    }
                    int rr = r;
                    int cc = c;
                    if (rr < 0) {
                        rr = 0;
                    }
                    if (rr >= matrix.length) {
                        rr = matrix.length - 1;
                    }
                    if (cc < 0) {
                        cc = 0;
                    }
                    if (cc >= matrix[0].length) {
                        cc = matrix[0].length - 1;
                    }
                    result[i][j] = matrix[rr][cc];
                }
            }
            return result;
        }
        double[][] result = Matrix.CreateMatrix2D(matrix.length + 2 * this.rows, matrix[0].length + 2 * this.cols, this.value);
        for (int i = 0; i < matrix.length; ++i) {
            System.arraycopy(matrix[i], 0, result[i + this.rows], this.cols, matrix[0].length);
        }
        return result;
    }
}

