/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Geometry;

import Catalano.Core.FloatPoint;
import Catalano.Core.IntPoint;

public class Line {
    private float k;
    private float b;

    public Line(IntPoint start, IntPoint end) {
        if (start.equals(end)) {
            try {
                throw new Exception("Start point of the line cannot be the same as its end point.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        float d = end.x - start.x;
        this.k = (float)(end.y - start.y) / d;
        this.b = Float.isInfinite(this.k) ? (float)start.x : (float)start.y - this.k * (float)start.x;
    }

    public Line(float slope, float intercept) {
        this.k = slope;
        this.b = intercept;
    }

    private Line(float radius, float theta, boolean unused) {
        float sine = (float)Math.sin(theta *= (float)Math.PI / 180);
        float cosine = (float)Math.cos(theta);
        FloatPoint pt1 = new FloatPoint(radius * cosine, radius * sine);
        this.k = -cosine / sine;
        this.b = !Float.isInfinite(this.k) ? pt1.y - this.k * pt1.x : Math.abs(radius);
    }

    private Line(IntPoint point, float theta) {
        this.k = (float)(-1.0 / Math.tan(theta *= (float)Math.PI / 180));
        this.b = !Float.isInfinite(this.k) ? (float)point.y - this.k * (float)point.x : (float)point.x;
    }

    public boolean isVertical() {
        return Float.isInfinite(this.k);
    }

    public boolean isHorizontal() {
        return this.k == 0.0f;
    }

    public float getSlope() {
        return this.k;
    }

    public float getIntercept() {
        return this.b;
    }

    public static Line FromPoints(IntPoint p1, IntPoint p2) {
        return new Line(p1, p2);
    }

    public static Line FromSlopeIntercept(float slope, float intercept) {
        return new Line(slope, intercept);
    }

    public static Line FromRTheta(float radius, float theta) {
        return new Line(radius, theta, false);
    }

    public static Line FromPointTheta(IntPoint p, float theta) {
        return new Line(p, theta);
    }

    public float GetAngleBetweenLines(Line secondLine) {
        float k2 = secondLine.k;
        boolean isVertical1 = this.isVertical();
        boolean isVertical2 = secondLine.isVertical();
        if (this.k == k2 || isVertical1 && isVertical2) {
            return 0.0f;
        }
        float angle = 0.0f;
        if (!isVertical1 && !isVertical2) {
            float tanPhi = (k2 > this.k ? k2 - this.k : this.k - k2) / (1.0f + this.k * k2);
            angle = (float)Math.atan(tanPhi);
        } else {
            angle = isVertical1 ? (float)(1.5707963267948966 - Math.atan(k2) * (double)Math.signum(k2)) : (float)(1.5707963267948966 - Math.atan(this.k) * (double)Math.signum(this.k));
        }
        angle *= 57.29578f;
        if (angle < 0.0f) {
            angle = -angle;
        }
        return angle;
    }

    public float DistanceToPoint(IntPoint point) {
        float distance;
        if (!this.isVertical()) {
            float div = (float)Math.sqrt(this.k * this.k + 1.0f);
            distance = Math.abs((this.k * (float)point.x + this.b - (float)point.y) / div);
        } else {
            distance = Math.abs(this.b - (float)point.x);
        }
        return distance;
    }
}

