/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Geometry;

import Catalano.Core.DoublePoint;
import Catalano.Core.DoubleRange;
import Catalano.Core.IntPoint;
import Catalano.Math.Tools;
import java.util.ArrayList;
import java.util.List;

public class KCurvature {
    public int k;
    public DoubleRange theta;
    private int suppression;

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public DoubleRange getTheta() {
        return this.theta;
    }

    public void setTheta(DoubleRange theta) {
        this.theta = theta;
    }

    public int getSuppression() {
        return this.suppression;
    }

    public void setSuppression(int suppression) {
        this.suppression = suppression;
    }

    public KCurvature(int k, DoubleRange theta) {
        this.k = k;
        this.theta = theta;
    }

    public List<IntPoint> FindPeaks(List<IntPoint> contour) {
        double[] map = new double[contour.size()];
        for (int i = 0; i < contour.size(); ++i) {
            double rs;
            double angbc;
            int ai = Tools.Mod(i + this.k, contour.size());
            int ci = Tools.Mod(i - this.k, contour.size());
            IntPoint a = contour.get(ai);
            IntPoint b = contour.get(i);
            IntPoint c = contour.get(ci);
            DoublePoint ab = new DoublePoint(b.x - a.x, b.y - a.y);
            DoublePoint cb = new DoublePoint(b.x - c.x, b.y - c.y);
            double angba = Math.atan2(ab.y, ab.x);
            double rslt = angba - (angbc = Math.atan2(cb.y, cb.x));
            if (rslt < 0.0) {
                rslt = Math.PI * 2 + rslt;
            }
            if (!this.theta.isInside(rs = rslt * 180.0 / Math.PI)) continue;
            map[i] = rs;
        }
        int r = this.suppression;
        ArrayList<IntPoint> peaks = new ArrayList<IntPoint>();
        for (int i = 0; i < map.length; ++i) {
            double current = map[i];
            if (current == 0.0) continue;
            boolean isMinimum = true;
            for (int j = -r; j < r && isMinimum; ++j) {
                int index = Tools.Mod(i + j, map.length);
                double candidate = map[index];
                if (candidate == 0.0) continue;
                if (candidate < current) {
                    isMinimum = false;
                    continue;
                }
                map[index] = 0.0;
            }
            if (!isMinimum) continue;
            peaks.add(contour.get(i));
        }
        return peaks;
    }
}

