/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions.Chaotic;

import Catalano.Math.Functions.Chaotic.IChaoticFunction;

public class TentMap
implements IChaoticFunction {
    private double u;
    private double threshold;

    public TentMap() {
        this(1.5, 0.5);
    }

    public TentMap(double u, double threshold) {
        this.u = u;
        this.threshold = threshold;
    }

    @Override
    public double Generate(double x) {
        if (x < this.threshold) {
            return this.u * x;
        }
        return this.u * (1.0 - x);
    }

    @Override
    public double[] Generate(double initialState, int iterations) {
        double[] map = new double[iterations];
        map[0] = initialState;
        for (int i = 1; i < iterations; ++i) {
            map[i] = this.Generate(map[i - 1]);
        }
        return map;
    }
}

