/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Distances;

import Catalano.Core.IntPoint;
import Catalano.Math.Matrix;

public final class Distance {
    private Distance() {
    }

    public static double ArithmeticGeometricDivergence(double[] p, double[] q) {
        double r = 0.0;
        for (int i = 0; i < p.length; ++i) {
            double den = p[i] * q[i];
            if (den == 0.0) continue;
            double num = p[i] + q[i];
            r += num / 2.0 * Math.log(num / (2.0 * Math.sqrt(den)));
        }
        return r;
    }

    public static double Bhattacharyya(double[] histogram1, double[] histogram2) {
        int bins = histogram1.length;
        double b = 0.0;
        for (int i = 0; i < bins; ++i) {
            b += Math.sqrt(histogram1[i]) * Math.sqrt(histogram2[i]);
        }
        return Math.sqrt(1.0 - b);
    }

    public static double BrayCurtis(double[] p, double[] q) {
        double sumN = 0.0;
        double sumP = 0.0;
        for (int i = 0; i < p.length; ++i) {
            sumN += Math.abs(p[i] - q[i]);
            sumP += Math.abs(p[i] + q[i]);
        }
        return sumN / sumP;
    }

    public static double BrayCurtis(double x1, double y1, double x2, double y2) {
        double sumN = Math.abs(x1 - x2) + Math.abs(y1 - y2);
        double sumP = Math.abs(x1 + x2) + Math.abs(y1 + y2);
        return sumN / sumP;
    }

    public static double BrayCurtis(IntPoint p, IntPoint q) {
        return Distance.BrayCurtis(p.x, p.y, q.x, q.y);
    }

    public static double Canberra(double[] p, double[] q) {
        double distance = 0.0;
        for (int i = 0; i < p.length; ++i) {
            distance += Math.abs(p[i] - q[i]) / (Math.abs(p[i]) + Math.abs(q[i]));
        }
        return distance;
    }

    public static double Canberra(double x1, double y1, double x2, double y2) {
        double distance = Math.abs(x1 - x2) / (Math.abs(x1) + Math.abs(x2));
        return distance += Math.abs(y1 - y2) / (Math.abs(y1) + Math.abs(y2));
    }

    public static double Canberra(IntPoint p, IntPoint q) {
        return Distance.Canberra(p.x, p.y, q.x, q.y);
    }

    public static double Chebyshev(double[] p, double[] q) {
        double max = Math.abs(p[0] - q[0]);
        for (int i = 1; i < p.length; ++i) {
            double abs = Math.abs(p[i] - q[i]);
            if (!(abs > max)) continue;
            max = abs;
        }
        return max;
    }

    public static double Chebyshev(double x1, double y1, double x2, double y2) {
        double max = Math.max(Math.abs(x1 - x2), Math.abs(y1 - y2));
        return max;
    }

    public static double Chebyshev(IntPoint p, IntPoint q) {
        return Distance.Chebyshev(p.x, p.y, q.x, q.y);
    }

    public static double Chessboard(double[] x, double[] y) {
        double d = 0.0;
        for (int i = 0; i < x.length; ++i) {
            d = Math.max(d, x[i] - y[i]);
        }
        return d;
    }

    public static double Chessboard(double x1, double y1, double x2, double y2) {
        double dx = Math.abs(x1 - x2);
        double dy = Math.abs(y1 - y2);
        return Math.max(dx, dy);
    }

    public static double Chessboard(IntPoint p, IntPoint q) {
        return Distance.Chessboard(p.x, p.y, q.x, q.y);
    }

    public static double ChiSquare(double[] histogram1, double[] histogram2) {
        double r = 0.0;
        for (int i = 0; i < histogram1.length; ++i) {
            double t = histogram1[i] + histogram2[i];
            if (t == 0.0) continue;
            r += Math.pow(histogram1[i] - histogram2[i], 2.0) / t;
        }
        return 0.5 * r;
    }

    public static double Correlation(double[] p, double[] q) {
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < p.length; ++i) {
            x += -p[i];
            y += -q[i];
        }
        x /= (double)p.length;
        y /= (double)q.length;
        double num = 0.0;
        double den1 = 0.0;
        double den2 = 0.0;
        for (int i = 0; i < p.length; ++i) {
            num += (p[i] + x) * (q[i] + y);
            den1 += Math.abs(Math.pow(p[i] + x, 2.0));
            den2 += Math.abs(Math.pow(q[i] + x, 2.0));
        }
        return 1.0 - num / (Math.sqrt(den1) * Math.sqrt(den2));
    }

    public static double Cosine(double[] p, double[] q) {
        double sumProduct = 0.0;
        double sumP = 0.0;
        double sumQ = 0.0;
        for (int i = 0; i < p.length; ++i) {
            sumProduct += p[i] * q[i];
            sumP += Math.pow(Math.abs(p[i]), 2.0);
            sumQ += Math.pow(Math.abs(q[i]), 2.0);
        }
        sumP = Math.sqrt(sumP);
        sumQ = Math.sqrt(sumQ);
        double result = 1.0 - sumProduct / (sumP * sumQ);
        return result;
    }

    public static double Cosine(double x1, double y1, double x2, double y2) {
        double sumProduct = x1 * x2 + y1 * y2;
        double sumP = Math.pow(Math.abs(x1), 2.0) + Math.pow(Math.abs(x2), 2.0);
        double sumQ = Math.pow(Math.abs(y1), 2.0) + Math.pow(Math.abs(y2), 2.0);
        sumP = Math.sqrt(sumP);
        sumQ = Math.sqrt(sumQ);
        double result = 1.0 - sumProduct / (sumP * sumQ);
        return result;
    }

    public static double Cosine(IntPoint p, IntPoint q) {
        return Distance.Cosine(p.x, p.y, q.x, q.y);
    }

    public static double Euclidean(double[] p, double[] q) {
        return Math.sqrt(Distance.SquaredEuclidean(p, q));
    }

    public static double Euclidean(double x1, double y1, double x2, double y2) {
        double dx = Math.abs(x1 - x2);
        double dy = Math.abs(y1 - y2);
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double Euclidean(IntPoint p, IntPoint q) {
        return Distance.Euclidean(p.x, p.y, q.x, q.y);
    }

    public static int Hamming(String first, String second) {
        if (first.length() != second.length()) {
            throw new IllegalArgumentException("The size of string must be the same.");
        }
        int diff = 0;
        for (int i = 0; i < first.length(); ++i) {
            if (first.charAt(i) == second.charAt(i)) continue;
            ++diff;
        }
        return diff;
    }

    public static double JaccardDistance(double[] p, double[] q) {
        double distance = 0.0;
        int intersection = 0;
        int union = 0;
        for (int x = 0; x < p.length; ++x) {
            if (p[x] == 0.0 && q[x] == 0.0) continue;
            if (p[x] == q[x]) {
                ++intersection;
            }
            ++union;
        }
        distance = union != 0 ? 1.0 - (double)intersection / (double)union : 0.0;
        return distance;
    }

    public static double JDivergence(double[] p, double[] q) {
        boolean intersection = false;
        double k = 0.0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == 0.0 || q[i] == 0.0) continue;
            intersection = true;
            k += (p[i] - q[i]) * Math.log(p[i] / q[i]);
        }
        if (intersection) {
            return k;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double JensenDifferenceDivergence(double[] p, double[] q) {
        boolean intersection = false;
        double k = 0.0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == 0.0 || q[i] == 0.0) continue;
            intersection = true;
            double pq = p[i] + q[i];
            k += (p[i] * Math.log(p[i]) + q[i] * Math.log(q[i])) / 2.0 - pq / 2.0 * Math.log(pq / 2.0);
        }
        if (intersection) {
            return k;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double JensenShannonDivergence(double[] p, double[] q) {
        double[] m = new double[p.length];
        for (int i = 0; i < m.length; ++i) {
            m[i] = (p[i] + q[i]) / 2.0;
        }
        return (Distance.KullbackLeiblerDivergence(p, m) + Distance.KullbackLeiblerDivergence(q, m)) / 2.0;
    }

    public static double KDivergence(double[] p, double[] q) {
        double r = 0.0;
        for (int i = 0; i < p.length; ++i) {
            double den = p[i] + q[i];
            if (den == 0.0 || p[i] == 0.0) continue;
            r += p[i] * Math.log(2.0 * p[i] / den);
        }
        return r;
    }

    public static double KumarJohnsonDivergence(double[] p, double[] q) {
        double r = 0.0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == 0.0 || q[i] == 0.0) continue;
            r += Math.pow(p[i] * p[i] - q[i] * q[i], 2.0) / 2.0 * Math.pow(p[i] * q[i], 1.5);
        }
        return r;
    }

    public static double KullbackLeiblerDivergence(double[] p, double[] q) {
        boolean intersection = false;
        double k = 0.0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == 0.0 || q[i] == 0.0) continue;
            intersection = true;
            k += p[i] * Math.log(p[i] / q[i]);
        }
        if (intersection) {
            return k;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double Mahalanobis(double[][] A, double[][] B) {
        if (A[0].length != B[0].length) {
            throw new IllegalArgumentException("The number of columns of both matrix must be equals.");
        }
        double[][] subA = new double[A.length][A[0].length];
        double[][] subB = new double[B.length][B[0].length];
        double[] meansA = new double[A[0].length];
        for (int j = 0; j < A[0].length; ++j) {
            int i;
            for (i = 0; i < A.length; ++i) {
                int n = j;
                meansA[n] = meansA[n] + A[i][j];
            }
            int n = j;
            meansA[n] = meansA[n] / (double)A.length;
            for (i = 0; i < A.length; ++i) {
                subA[i][j] = A[i][j] - meansA[j];
            }
        }
        double[] meansB = new double[B[0].length];
        for (int j = 0; j < B[0].length; ++j) {
            int i;
            for (i = 0; i < B.length; ++i) {
                int n = j;
                meansB[n] = meansB[n] + B[i][j];
            }
            int n = j;
            meansB[n] = meansB[n] / (double)B.length;
            for (i = 0; i < B.length; ++i) {
                subB[i][j] = B[i][j] - meansB[j];
            }
        }
        double[][] covA = Distance.Covariance(subA);
        double[][] covB = Distance.Covariance(subB);
        double rows = subA.length + subB.length;
        double[][] pCov = new double[covA.length][covA[0].length];
        for (int i = 0; i < pCov.length; ++i) {
            for (int j = 0; j < pCov[0].length; ++j) {
                pCov[i][j] = covA[i][j] * ((double)subA.length / rows) + covB[i][j] * ((double)subB.length / rows);
            }
        }
        pCov = Matrix.Inverse(pCov);
        double[] diff = new double[A[0].length];
        for (int i = 0; i < diff.length; ++i) {
            diff[i] = meansA[i] - meansB[i];
        }
        return Math.sqrt(Matrix.InnerProduct(Matrix.MultiplyByTranspose(pCov, diff), diff));
    }

    private static double Covariance(double[] x, double[] y, double meanX, double meanY) {
        double result = 0.0;
        for (int i = 0; i < x.length; ++i) {
            result += (x[i] - meanX) * (y[i] - meanY);
        }
        return result / (double)x.length;
    }

    private static double[][] Covariance(double[][] matrix) {
        int i;
        double[] means = new double[matrix[0].length];
        for (i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                int n = j;
                means[n] = means[n] + matrix[i][j];
            }
        }
        i = 0;
        while (i < means.length) {
            int n = i++;
            means[n] = means[n] / (double)means.length;
        }
        return Distance.Covariance(matrix, means);
    }

    private static double[][] Covariance(double[][] matrix, double[] means) {
        double[][] cov = new double[means.length][means.length];
        for (int i = 0; i < cov.length; ++i) {
            for (int j = 0; j < cov[0].length; ++j) {
                cov[i][j] = Distance.Covariance(Matrix.getColumn(matrix, i), Matrix.getColumn(matrix, j), means[i], means[j]);
            }
        }
        return cov;
    }

    public static double Manhattan(double[] p, double[] q) {
        double sum = 0.0;
        for (int i = 0; i < p.length; ++i) {
            sum += Math.abs(p[i] - q[i]);
        }
        return sum;
    }

    public static double Manhattan(double x1, double y1, double x2, double y2) {
        double dx = Math.abs(x1 - x2);
        double dy = Math.abs(y1 - y2);
        return dx + dy;
    }

    public static double Manhattan(IntPoint p, IntPoint q) {
        return Distance.Manhattan(p.x, p.y, q.x, q.y);
    }

    public static double Minkowski(double x1, double y1, double x2, double y2, int r) {
        double sum = Math.pow(Math.abs(x1 - x2), r);
        return Math.pow(sum += Math.pow(Math.abs(y1 - y2), r), 1 / r);
    }

    public static double Minkowski(IntPoint p, IntPoint q, int r) {
        return Distance.Minkowski(p.x, p.y, q.x, q.y, r);
    }

    public static double Minkowski(double[] u, double[] v, double p) {
        double distance = 0.0;
        for (int i = 0; i < u.length; ++i) {
            distance += Math.pow(Math.abs(u[i] - v[i]), p);
        }
        return Math.pow(distance, 1.0 / p);
    }

    public static double QuasiEuclidean(double x1, double y1, double x2, double y2) {
        if (Math.abs(x1 - x2) > Math.abs(y1 - y2)) {
            return Math.abs(x1 - x2) + 0.41421356237309515 * Math.abs(y1 - y2);
        }
        return 0.41421356237309515 * Math.abs(x1 - x2) + Math.abs(y1 - y2);
    }

    public static double QuasiEuclidean(IntPoint p, IntPoint q) {
        return Distance.QuasiEuclidean(p.x, p.y, q.x, q.y);
    }

    public static double SquaredEuclidean(double[] x, double[] y) {
        double d = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double u = x[i] - y[i];
            d += u * u;
        }
        return d;
    }

    public static double SquaredEuclidean(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    public static double SquaredEuclidean(IntPoint p, IntPoint q) {
        double dx = q.x - p.x;
        double dy = q.y - p.y;
        return dx * dx + dy * dy;
    }

    public static double SymmetricChiSquareDivergence(double[] p, double[] q) {
        double r = 0.0;
        for (int i = 0; i < p.length; ++i) {
            double den = p[i] * q[i];
            if (den == 0.0) continue;
            double p1 = p[i] - q[i];
            double p2 = p[i] + q[i];
            r += p1 * p1 * p2 / den;
        }
        return r;
    }

    public static double SymmetricKullbackLeibler(double[] p, double[] q) {
        double dist = 0.0;
        for (int i = 0; i < p.length; ++i) {
            dist += (p[i] - q[i]) * (Math.log(p[i]) - Math.log(q[i]));
        }
        return dist;
    }

    public static double Taneja(double[] p, double[] q) {
        double r = 0.0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == 0.0 || q[i] == 0.0) continue;
            double pq = p[i] + q[i];
            r += pq / 2.0 * Math.log(pq / (2.0 * Math.sqrt(p[i] * q[i])));
        }
        return r;
    }

    public static double TopsoeDivergence(double[] p, double[] q) {
        double r = 0.0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == 0.0 || q[i] == 0.0) continue;
            double den = p[i] + q[i];
            r += p[i] * Math.log(2.0 * p[i] / den) + q[i] * Math.log(2.0 * q[i] / den);
        }
        return r;
    }
}

