/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Decompositions;

import Catalano.Math.Tools;
import java.io.Serializable;

public class QRDecomposition
implements Serializable {
    private double[][] QR;
    private int m;
    private int n;
    private double[] Rdiag;

    public QRDecomposition(double[][] matrix) {
        this.QR = (double[][])matrix.clone();
        this.m = matrix.length;
        this.n = matrix[0].length;
        this.Rdiag = new double[this.n];
        for (int k = 0; k < this.n; ++k) {
            int i;
            double nrm = 0.0;
            for (i = k; i < this.m; ++i) {
                nrm = Tools.Hypotenuse(nrm, this.QR[i][k]);
            }
            if (nrm != 0.0) {
                if (this.QR[k][k] < 0.0) {
                    nrm = -nrm;
                }
                for (i = k; i < this.m; ++i) {
                    double[] dArray = this.QR[i];
                    int n = k;
                    dArray[n] = dArray[n] / nrm;
                }
                double[] dArray = this.QR[k];
                int n = k;
                dArray[n] = dArray[n] + 1.0;
                for (int j = k + 1; j < this.n; ++j) {
                    int i2;
                    double s = 0.0;
                    for (i2 = k; i2 < this.m; ++i2) {
                        s += this.QR[i2][k] * this.QR[i2][j];
                    }
                    s = -s / this.QR[k][k];
                    for (i2 = k; i2 < this.m; ++i2) {
                        double[] dArray2 = this.QR[i2];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + s * this.QR[i2][k];
                    }
                }
            }
            this.Rdiag[k] = -nrm;
        }
    }

    public boolean isFullRank() {
        for (int j = 0; j < this.n; ++j) {
            if (this.Rdiag[j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public double[][] getH() {
        double[][] X;
        double[][] H = X = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                H[i][j] = i >= j ? this.QR[i][j] : 0.0;
            }
        }
        return X;
    }

    public double[][] getR() {
        double[][] X;
        double[][] R = X = new double[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                R[i][j] = i < j ? this.QR[i][j] : (i == j ? this.Rdiag[i] : 0.0);
            }
        }
        return X;
    }

    public double[][] getQ() {
        double[][] X;
        double[][] Q = X = new double[this.m][this.n];
        for (int k = this.n - 1; k >= 0; --k) {
            for (int i = 0; i < this.m; ++i) {
                Q[i][k] = 0.0;
            }
            Q[k][k] = 1.0;
            for (int j = k; j < this.n; ++j) {
                int i;
                if (this.QR[k][k] == 0.0) continue;
                double s = 0.0;
                for (i = k; i < this.m; ++i) {
                    s += this.QR[i][k] * Q[i][j];
                }
                s = -s / this.QR[k][k];
                for (i = k; i < this.m; ++i) {
                    double[] dArray = Q[i];
                    int n = j;
                    dArray[n] = dArray[n] + s * this.QR[i][k];
                }
            }
        }
        return X;
    }

    public double[][] solve(double[][] B) {
        int i;
        int j;
        int k;
        if (B.length != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int nx = B[0].length;
        double[][] X = (double[][])B.clone();
        for (k = 0; k < this.n; ++k) {
            for (j = 0; j < nx; ++j) {
                int i2;
                double s = 0.0;
                for (i2 = k; i2 < this.m; ++i2) {
                    s += this.QR[i2][k] * X[i2][j];
                }
                s = -s / this.QR[k][k];
                for (i2 = k; i2 < this.m; ++i2) {
                    double[] dArray = X[i2];
                    int n = j;
                    dArray[n] = dArray[n] + s * this.QR[i2][k];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.Rdiag[k];
            }
            for (i = 0; i < k; ++i) {
                for (int j2 = 0; j2 < nx; ++j2) {
                    double[] dArray = X[i];
                    int n = j2;
                    dArray[n] = dArray[n] - X[k][j2] * this.QR[i][k];
                }
            }
        }
        double[][] mat = new double[this.n][nx];
        for (i = 0; i < mat.length; ++i) {
            for (int j3 = 0; j3 < mat[0].length; ++j3) {
                mat[i][j3] = X[i][j3];
            }
        }
        return mat;
    }
}

