/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Regression.RegressionTrees;

import Catalano.Core.ArraysUtil;
import Catalano.Core.Concurrent.MulticoreExecutor;
import Catalano.MachineLearning.Dataset.DatasetRegression;
import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.Regression.IRegression;
import Catalano.Math.Tools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;

public class RegressionTree
implements IRegression,
Serializable {
    private int[] samples;
    private NodeOutput nodeOutput;
    private DecisionVariable[] attributes;
    private double[] importance;
    private Node root;
    private int S = 5;
    private int J = 6;
    private int M;
    private int numFeatures;
    private transient int[][] order;

    public int getNumberOfLeafs() {
        return this.J;
    }

    public void setNumberOfLeafs(int J) {
        this.J = J;
    }

    public double[] getImportance() {
        return this.importance;
    }

    public RegressionTree() {
        this(6);
    }

    public RegressionTree(DecisionVariable[] attributes) {
        this(attributes, 6);
    }

    public RegressionTree(int J) {
        this(null, J);
    }

    public RegressionTree(DecisionVariable[] attributes, int J) {
        this(attributes, J, null, null, null);
    }

    private void BuildModel(DecisionVariable[] attributes, double[][] x, double[] y, int J, int[][] order, int[] samples, NodeOutput output) {
        TrainNode node;
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (J < 2) {
            throw new IllegalArgumentException("Invalid maximum leaves: " + J);
        }
        if (attributes == null) {
            int p = x[0].length;
            attributes = new DecisionVariable[p];
            for (int i2 = 0; i2 < p; ++i2) {
                attributes[i2] = new DecisionVariable("F" + i2);
            }
        }
        this.attributes = attributes;
        this.J = J;
        this.M = attributes.length;
        this.importance = new double[attributes.length];
        if (order != null) {
            this.order = order;
        } else {
            int n = x.length;
            int p = x[0].length;
            double[] a = new double[n];
            this.order = new int[p][];
            for (int j = 0; j < p; ++j) {
                for (i = 0; i < n; ++i) {
                    a[i] = x[i][j];
                }
                this.order[j] = ArraysUtil.Argsort(a, true);
            }
        }
        PriorityQueue<TrainNode> nextSplits = new PriorityQueue<TrainNode>();
        int n = 0;
        double sum = 0.0;
        if (samples == null) {
            n = y.length;
            samples = new int[n];
            for (i = 0; i < n; ++i) {
                samples[i] = 1;
                sum += y[i];
            }
        } else {
            for (i = 0; i < y.length; ++i) {
                n += samples[i];
                sum += (double)samples[i] * y[i];
            }
        }
        this.root = new Node(sum / (double)n);
        TrainNode trainRoot = new TrainNode(this.root, x, y, samples);
        if (trainRoot.findBestSplit()) {
            nextSplits.add(trainRoot);
        }
        for (int leaves = 1; leaves < this.J && (node = (TrainNode)nextSplits.poll()) != null; ++leaves) {
            node.split(nextSplits);
        }
        if (output != null) {
            trainRoot.calculateOutput(output);
        }
    }

    public RegressionTree(DecisionVariable[] attributes, int J, int[][] order, int[] samples, NodeOutput output) {
        this.attributes = attributes;
        this.J = J;
        this.order = order;
        this.samples = samples;
        this.nodeOutput = output;
    }

    public RegressionTree(DecisionVariable[] attributes, double[][] x, double[] y, int M, int S, int[][] order, int[] samples) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (M <= 0 || M > x[0].length) {
            throw new IllegalArgumentException("Invalid number of variables to split on at a node of the tree: " + M);
        }
        if (S <= 0) {
            throw new IllegalArgumentException("Invalid mimum number of instances in leaf nodes: " + S);
        }
        if (samples == null) {
            throw new IllegalArgumentException("Sampling array is null.");
        }
        if (attributes == null) {
            int p = x[0].length;
            attributes = new DecisionVariable[p];
            for (int i = 0; i < p; ++i) {
                attributes[i] = new DecisionVariable("F" + i);
            }
        }
        this.attributes = attributes;
        this.J = Integer.MAX_VALUE;
        this.M = M;
        this.S = S;
        this.order = order;
        this.importance = new double[attributes.length];
        int n = 0;
        double sum = 0.0;
        for (int i = 0; i < y.length; ++i) {
            n += samples[i];
            sum += (double)samples[i] * y[i];
        }
        this.root = new Node(sum / (double)n);
        TrainNode trainRoot = new TrainNode(this.root, x, y, samples);
        if (trainRoot.findBestSplit()) {
            trainRoot.split(null);
        }
    }

    public RegressionTree(int numFeatures, int[][] x, double[] y, int J) {
        this(numFeatures, x, y, J, null, null);
    }

    public RegressionTree(int numFeatures, int[][] x, double[] y, int J, int[] samples, NodeOutput output) {
        SparseBinaryTrainNode node;
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (J < 2) {
            throw new IllegalArgumentException("Invalid maximum leaves: " + J);
        }
        this.J = J;
        this.numFeatures = numFeatures;
        this.importance = new double[numFeatures];
        PriorityQueue<SparseBinaryTrainNode> nextSplits = new PriorityQueue<SparseBinaryTrainNode>();
        int n = 0;
        double sum = 0.0;
        if (samples == null) {
            n = y.length;
            samples = new int[n];
            for (i = 0; i < n; ++i) {
                samples[i] = 1;
                sum += y[i];
            }
        } else {
            for (i = 0; i < y.length; ++i) {
                n += samples[i];
                sum += (double)samples[i] * y[i];
            }
        }
        this.root = new Node(sum / (double)n);
        SparseBinaryTrainNode trainRoot = new SparseBinaryTrainNode(this.root, x, y, samples);
        if (trainRoot.findBestSplit()) {
            nextSplits.add(trainRoot);
        }
        for (int leaves = 1; leaves < this.J && (node = (SparseBinaryTrainNode)nextSplits.poll()) != null; ++leaves) {
            node.split(nextSplits);
        }
        if (output != null) {
            trainRoot.calculateOutput(output);
        }
    }

    @Override
    public void Learn(DatasetRegression dataset) {
        this.Learn(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Learn(double[][] input, double[] output) {
        this.BuildModel(this.attributes, input, output, this.J, this.order, this.samples, this.nodeOutput);
    }

    @Override
    public double Predict(double[] feature) {
        return this.root.predict(feature);
    }

    public double Predict(int[] feature) {
        return this.root.predict(feature);
    }

    @Override
    public IRegression clone() {
        try {
            return (IRegression)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported: " + ex.getMessage());
        }
    }

    class SparseBinaryTrainNode
    implements Comparable<SparseBinaryTrainNode> {
        Node node;
        SparseBinaryTrainNode trueChild;
        SparseBinaryTrainNode falseChild;
        int[][] x;
        double[] y;
        int[] samples;

        public SparseBinaryTrainNode(Node node, int[][] x, double[] y, int[] samples) {
            this.node = node;
            this.x = x;
            this.y = y;
            this.samples = samples;
        }

        @Override
        public int compareTo(SparseBinaryTrainNode a) {
            return (int)Math.signum(a.node.splitScore - this.node.splitScore);
        }

        public boolean findBestSplit() {
            int i;
            if (this.node.trueChild != null || this.node.falseChild != null) {
                throw new IllegalStateException("Split non-leaf node.");
            }
            int p = RegressionTree.this.numFeatures;
            double[] trueSum = new double[p];
            int[] trueCount = new int[p];
            int[] featureIndex = new int[p];
            int n = Tools.Sum(this.samples);
            double sumX = 0.0;
            for (i = 0; i < this.x.length; ++i) {
                if (this.samples[i] == 0) continue;
                double target = (double)this.samples[i] * this.y[i];
                sumX += this.y[i];
                int j = 0;
                while (j < this.x[i].length) {
                    int index;
                    int n2 = index = this.x[i][j];
                    trueSum[n2] = trueSum[n2] + target;
                    int n3 = index;
                    trueCount[n3] = trueCount[n3] + this.samples[i];
                    featureIndex[index] = j++;
                }
            }
            this.node.splitScore = 0.0;
            this.node.splitFeature = -1;
            this.node.splitValue = -1.0;
            for (i = 0; i < p; ++i) {
                double falseMean;
                double trueMean;
                double gain;
                double tc = trueCount[i];
                double fc = (double)n - tc;
                if (tc < 2.0 || fc < 2.0 || !((gain = tc * (trueMean = trueSum[i] / tc) * trueMean + fc * (falseMean = (sumX - trueSum[i]) / fc) * falseMean - (double)n * this.node.output * this.node.output) > this.node.splitScore)) continue;
                this.node.splitFeature = featureIndex[i];
                this.node.splitValue = i;
                this.node.splitScore = gain;
                this.node.trueChildOutput = trueMean;
                this.node.falseChildOutput = falseMean;
            }
            return this.node.splitFeature != -1;
        }

        public void split(PriorityQueue<SparseBinaryTrainNode> nextSplits) {
            if (this.node.splitFeature < 0) {
                throw new IllegalStateException("Split a node with invalid feature.");
            }
            if (this.node.trueChild != null || this.node.falseChild != null) {
                throw new IllegalStateException("Split non-leaf node.");
            }
            int n = this.x.length;
            int tc = 0;
            int fc = 0;
            int[] trueSamples = new int[n];
            int[] falseSamples = new int[n];
            for (int i = 0; i < n; ++i) {
                if (this.samples[i] <= 0) continue;
                if (this.x[i][this.node.splitFeature] == (int)this.node.splitValue) {
                    trueSamples[i] = this.samples[i];
                    tc += this.samples[i];
                    continue;
                }
                falseSamples[i] = this.samples[i];
                fc += this.samples[i];
            }
            this.node.trueChild = new Node(this.node.trueChildOutput);
            this.node.falseChild = new Node(this.node.falseChildOutput);
            this.trueChild = new SparseBinaryTrainNode(this.node.trueChild, this.x, this.y, trueSamples);
            if (tc > RegressionTree.this.S && this.trueChild.findBestSplit()) {
                if (nextSplits != null) {
                    nextSplits.add(this.trueChild);
                } else {
                    this.trueChild.split(null);
                }
            }
            this.falseChild = new SparseBinaryTrainNode(this.node.falseChild, this.x, this.y, falseSamples);
            if (fc > RegressionTree.this.S && this.falseChild.findBestSplit()) {
                if (nextSplits != null) {
                    nextSplits.add(this.falseChild);
                } else {
                    this.falseChild.split(null);
                }
            }
            double[] dArray = RegressionTree.this.importance;
            int n2 = this.node.splitFeature;
            dArray[n2] = dArray[n2] + this.node.splitScore;
        }

        public void calculateOutput(NodeOutput output) {
            if (this.node.trueChild == null && this.node.falseChild == null) {
                this.node.output = output.calculate(this.samples);
            } else {
                if (this.trueChild != null) {
                    this.trueChild.calculateOutput(output);
                }
                if (this.falseChild != null) {
                    this.falseChild.calculateOutput(output);
                }
            }
        }
    }

    class TrainNode
    implements Comparable<TrainNode> {
        Node node;
        TrainNode trueChild;
        TrainNode falseChild;
        double[][] x;
        double[] y;
        int[] samples;

        public TrainNode(Node node, double[][] x, double[] y, int[] samples) {
            this.node = node;
            this.x = x;
            this.y = y;
            this.samples = samples;
        }

        @Override
        public int compareTo(TrainNode a) {
            return (int)Math.signum(a.node.splitScore - this.node.splitScore);
        }

        public void calculateOutput(NodeOutput output) {
            if (this.node.trueChild == null && this.node.falseChild == null) {
                this.node.output = output.calculate(this.samples);
            } else {
                if (this.trueChild != null) {
                    this.trueChild.calculateOutput(output);
                }
                if (this.falseChild != null) {
                    this.falseChild.calculateOutput(output);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean findBestSplit() {
            int n = 0;
            for (int s : this.samples) {
                n += s;
            }
            if (n <= RegressionTree.this.S) {
                return false;
            }
            double sum = this.node.output * (double)n;
            int p = RegressionTree.this.attributes.length;
            int[] variables = new int[p];
            for (int i = 0; i < p; ++i) {
                variables[i] = i;
            }
            if (RegressionTree.this.M < p) {
                Class<RegressionTree> i = RegressionTree.class;
                synchronized (RegressionTree.class) {
                    Tools.Permutate(variables);
                    // ** MonitorExit[i] (shouldn't be in output)
                    for (int j = 0; j < RegressionTree.this.M; ++j) {
                        Node split = this.findBestSplit(n, sum, variables[j]);
                        if (!(split.splitScore > this.node.splitScore)) continue;
                        this.node.splitFeature = split.splitFeature;
                        this.node.splitValue = split.splitValue;
                        this.node.splitScore = split.splitScore;
                        this.node.trueChildOutput = split.trueChildOutput;
                        this.node.falseChildOutput = split.falseChildOutput;
                    }
                }
            } else {
                ArrayList<SplitTask> tasks = new ArrayList<SplitTask>(RegressionTree.this.M);
                for (int j = 0; j < RegressionTree.this.M; ++j) {
                    tasks.add(new SplitTask(n, sum, variables[j]));
                }
                try {
                    for (Node split : MulticoreExecutor.run(tasks)) {
                        if (!(split.splitScore > this.node.splitScore)) continue;
                        this.node.splitFeature = split.splitFeature;
                        this.node.splitValue = split.splitValue;
                        this.node.splitScore = split.splitScore;
                        this.node.trueChildOutput = split.trueChildOutput;
                        this.node.falseChildOutput = split.falseChildOutput;
                    }
                }
                catch (Exception ex) {
                    for (int j = 0; j < RegressionTree.this.M; ++j) {
                        Node split = this.findBestSplit(n, sum, variables[j]);
                        if (!(split.splitScore > this.node.splitScore)) continue;
                        this.node.splitFeature = split.splitFeature;
                        this.node.splitValue = split.splitValue;
                        this.node.splitScore = split.splitScore;
                        this.node.trueChildOutput = split.trueChildOutput;
                        this.node.falseChildOutput = split.falseChildOutput;
                    }
                }
            }
            {
                if (this.node.splitFeature == -1) return false;
                return true;
            }
        }

        public Node findBestSplit(int n, double sum, int j) {
            int N = this.x.length;
            Node split = new Node(0.0);
            if (((RegressionTree)RegressionTree.this).attributes[j].type == DecisionVariable.Type.Discrete) {
                int m = this.x.length;
                double[] trueSum = new double[m];
                int[] trueCount = new int[m];
                for (int i = 0; i < N; ++i) {
                    int index;
                    if (this.samples[i] <= 0) continue;
                    double target = (double)this.samples[i] * this.y[i];
                    int n2 = index = (int)this.x[i][j];
                    trueSum[n2] = trueSum[n2] + target;
                    int n3 = index;
                    trueCount[n3] = trueCount[n3] + this.samples[i];
                }
                for (int k = 0; k < m; ++k) {
                    double falseMean;
                    double trueMean;
                    double gain;
                    double tc = trueCount[k];
                    double fc = (double)n - tc;
                    if (tc == 0.0 || fc == 0.0 || !((gain = tc * (trueMean = trueSum[k] / tc) * trueMean + fc * (falseMean = (sum - trueSum[k]) / fc) * falseMean - (double)n * split.output * split.output) > split.splitScore)) continue;
                    split.splitFeature = j;
                    split.splitValue = k;
                    split.splitScore = gain;
                    split.trueChildOutput = trueMean;
                    split.falseChildOutput = falseMean;
                }
            } else if (((RegressionTree)RegressionTree.this).attributes[j].type == DecisionVariable.Type.Continuous) {
                double trueSum = 0.0;
                int trueCount = 0;
                double prevx = Double.NaN;
                for (int i : RegressionTree.this.order[j]) {
                    if (this.samples[i] <= 0) continue;
                    if (Double.isNaN(prevx) || this.x[i][j] == prevx) {
                        prevx = this.x[i][j];
                        trueSum += (double)this.samples[i] * this.y[i];
                        trueCount += this.samples[i];
                        continue;
                    }
                    double falseCount = n - trueCount;
                    if (trueCount == 0 || falseCount == 0.0) {
                        prevx = this.x[i][j];
                        trueSum += (double)this.samples[i] * this.y[i];
                        trueCount += this.samples[i];
                        continue;
                    }
                    double trueMean = trueSum / (double)trueCount;
                    double falseMean = (sum - trueSum) / falseCount;
                    double gain = (double)trueCount * trueMean * trueMean + falseCount * falseMean * falseMean - (double)n * split.output * split.output;
                    if (gain > split.splitScore) {
                        split.splitFeature = j;
                        split.splitValue = (this.x[i][j] + prevx) / 2.0;
                        split.splitScore = gain;
                        split.trueChildOutput = trueMean;
                        split.falseChildOutput = falseMean;
                    }
                    prevx = this.x[i][j];
                    trueSum += (double)this.samples[i] * this.y[i];
                    trueCount += this.samples[i];
                }
            } else {
                throw new IllegalStateException("Unsupported attribute type: " + (Object)((Object)((RegressionTree)RegressionTree.this).attributes[j].type));
            }
            return split;
        }

        public boolean split(PriorityQueue<TrainNode> nextSplits) {
            if (this.node.splitFeature < 0) {
                throw new IllegalStateException("Split a node with invalid feature.");
            }
            int n = this.x.length;
            int tc = 0;
            int fc = 0;
            int[] trueSamples = new int[n];
            int[] falseSamples = new int[n];
            if (((RegressionTree)RegressionTree.this).attributes[this.node.splitFeature].type == DecisionVariable.Type.Discrete) {
                for (int i = 0; i < n; ++i) {
                    if (this.samples[i] <= 0) continue;
                    if (this.x[i][this.node.splitFeature] == this.node.splitValue) {
                        trueSamples[i] = this.samples[i];
                        tc += this.samples[i];
                        continue;
                    }
                    falseSamples[i] = this.samples[i];
                    fc += this.samples[i];
                }
            } else if (((RegressionTree)RegressionTree.this).attributes[this.node.splitFeature].type == DecisionVariable.Type.Continuous) {
                for (int i = 0; i < n; ++i) {
                    if (this.samples[i] <= 0) continue;
                    if (this.x[i][this.node.splitFeature] <= this.node.splitValue) {
                        trueSamples[i] = this.samples[i];
                        tc += this.samples[i];
                        continue;
                    }
                    falseSamples[i] = this.samples[i];
                    fc += this.samples[i];
                }
            } else {
                throw new IllegalStateException("Unsupported attribute type: " + (Object)((Object)((RegressionTree)RegressionTree.this).attributes[this.node.splitFeature].type));
            }
            if (tc == 0 || fc == 0) {
                this.node.splitFeature = -1;
                this.node.splitValue = Double.NaN;
                this.node.splitScore = 0.0;
                return false;
            }
            this.node.trueChild = new Node(this.node.trueChildOutput);
            this.node.falseChild = new Node(this.node.falseChildOutput);
            this.trueChild = new TrainNode(this.node.trueChild, this.x, this.y, trueSamples);
            if (tc > RegressionTree.this.S && this.trueChild.findBestSplit()) {
                if (nextSplits != null) {
                    nextSplits.add(this.trueChild);
                } else {
                    this.trueChild.split(null);
                }
            }
            this.falseChild = new TrainNode(this.node.falseChild, this.x, this.y, falseSamples);
            if (fc > RegressionTree.this.S && this.falseChild.findBestSplit()) {
                if (nextSplits != null) {
                    nextSplits.add(this.falseChild);
                } else {
                    this.falseChild.split(null);
                }
            }
            double[] dArray = RegressionTree.this.importance;
            int n2 = this.node.splitFeature;
            dArray[n2] = dArray[n2] + this.node.splitScore;
            return true;
        }

        class SplitTask
        implements Callable<Node> {
            int n;
            double sum;
            int j;

            SplitTask(int n, double sum, int j) {
                this.n = n;
                this.sum = sum;
                this.j = j;
            }

            @Override
            public Node call() {
                return TrainNode.this.findBestSplit(this.n, this.sum, this.j);
            }
        }
    }

    class Node
    implements Serializable {
        double output = 0.0;
        int splitFeature = -1;
        double splitValue = Double.NaN;
        double splitScore = 0.0;
        Node trueChild;
        Node falseChild;
        double trueChildOutput = 0.0;
        double falseChildOutput = 0.0;

        public Node(double output) {
            this.output = output;
        }

        public double predict(double[] x) {
            if (this.trueChild == null && this.falseChild == null) {
                return this.output;
            }
            if (((RegressionTree)RegressionTree.this).attributes[this.splitFeature].type == DecisionVariable.Type.Discrete) {
                if (x[this.splitFeature] == this.splitValue) {
                    return this.trueChild.predict(x);
                }
                return this.falseChild.predict(x);
            }
            if (((RegressionTree)RegressionTree.this).attributes[this.splitFeature].type == DecisionVariable.Type.Continuous) {
                if (x[this.splitFeature] <= this.splitValue) {
                    return this.trueChild.predict(x);
                }
                return this.falseChild.predict(x);
            }
            throw new IllegalStateException("Unsupported attribute type: " + (Object)((Object)((RegressionTree)RegressionTree.this).attributes[this.splitFeature].type));
        }

        public double predict(int[] x) {
            if (this.trueChild == null && this.falseChild == null) {
                return this.output;
            }
            if (x[this.splitFeature] == (int)this.splitValue) {
                return this.trueChild.predict(x);
            }
            return this.falseChild.predict(x);
        }
    }

    public static interface NodeOutput {
        public double calculate(int[] var1);
    }
}

