/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Regression.RegressionTrees.Learning;

import Catalano.Core.ArraysUtil;
import Catalano.MachineLearning.Dataset.DatasetRegression;
import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.Regression.IRegression;
import Catalano.MachineLearning.Regression.RegressionTrees.RegressionTree;
import Catalano.Statistics.DescriptiveStatistics;
import Catalano.Statistics.Tools;
import java.io.Serializable;
import java.util.Arrays;

public class GradientBoostingTree
implements IRegression,
Serializable {
    private DecisionVariable[] attributes = null;
    private RegressionTree[] trees;
    private double b = 0.0;
    private double[] importance;
    private Loss loss = Loss.LeastAbsoluteDeviation;
    private double shrinkage = 0.005;
    private int J = 6;
    private int T = 500;
    private double f = 0.7;

    public GradientBoostingTree() {
        this(500);
    }

    public GradientBoostingTree(int T) {
        this(T, 6);
    }

    public GradientBoostingTree(int T, int J) {
        this(T, J, Loss.LeastSquares);
    }

    public GradientBoostingTree(int T, int J, Loss loss) {
        this(T, J, loss, 0.005);
    }

    public GradientBoostingTree(int T, int J, Loss loss, double shrinkage) {
        this(T, J, loss, shrinkage, 0.7);
    }

    public GradientBoostingTree(int T, int J, Loss loss, double shrinkage, double f) {
        this(null, T, J, loss, shrinkage, f);
    }

    public GradientBoostingTree(DecisionVariable[] attributes) {
        this(attributes, 500);
    }

    public GradientBoostingTree(DecisionVariable[] attributes, int T) {
        this(attributes, T, 6);
    }

    public GradientBoostingTree(DecisionVariable[] attributes, int T, int J) {
        this(attributes, T, J, Loss.LeastSquares);
    }

    public GradientBoostingTree(DecisionVariable[] attributes, int T, int J, Loss loss) {
        this(attributes, T, J, loss, 0.005);
    }

    public GradientBoostingTree(DecisionVariable[] attributes, int T, int J, Loss loss, double shrinkage) {
        this(attributes, T, J, loss, shrinkage, 0.7);
    }

    public GradientBoostingTree(DecisionVariable[] attributes, int T, int J, Loss loss, double shrinkage, double f) {
        this.attributes = attributes;
        this.loss = loss;
        this.T = T;
        this.J = J;
        this.shrinkage = shrinkage;
        this.f = f;
    }

    @Override
    public void Learn(DatasetRegression dataset) {
        this.Learn(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Learn(double[][] input, double[] output) {
        int i;
        if (input.length != output.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", input.length, output.length));
        }
        if (this.shrinkage <= 0.0 || this.shrinkage > 1.0) {
            throw new IllegalArgumentException("Invalid shrinkage: " + this.shrinkage);
        }
        if (this.f <= 0.0 || this.f > 1.0) {
            throw new IllegalArgumentException("Invalid sampling fraction: " + this.f);
        }
        if (this.attributes == null) {
            int p = input[0].length;
            this.attributes = new DecisionVariable[p];
            for (int i2 = 0; i2 < p; ++i2) {
                this.attributes[i2] = new DecisionVariable("F" + i2);
            }
        }
        int n = input.length;
        int N = (int)Math.round((double)n * this.f);
        int[] perm = new int[n];
        int[] samples = new int[n];
        for (int i3 = 0; i3 < n; ++i3) {
            perm[i3] = i3;
        }
        double[] residual = new double[n];
        double[] response = null;
        RegressionTree.NodeOutput nodeOutput = null;
        if (this.loss == Loss.LeastSquares) {
            response = residual;
            this.b = Tools.Mean(output);
            for (i = 0; i < n; ++i) {
                residual[i] = output[i] - this.b;
            }
        } else if (this.loss == Loss.LeastAbsoluteDeviation) {
            nodeOutput = new LADNodeOutput(residual);
            System.arraycopy(output, 0, residual, 0, n);
            this.b = DescriptiveStatistics.Median(residual);
            response = new double[n];
            for (i = 0; i < n; ++i) {
                residual[i] = output[i] - this.b;
                response[i] = Math.signum(residual[i]);
            }
        } else if (this.loss == Loss.Huber) {
            response = new double[n];
            System.arraycopy(output, 0, residual, 0, n);
            this.b = DescriptiveStatistics.Median(residual);
            for (i = 0; i < n; ++i) {
                residual[i] = output[i] - this.b;
            }
        }
        int[][] order = this.sort(this.attributes, input);
        this.trees = new RegressionTree[this.T];
        for (int m = 0; m < this.T; ++m) {
            int i4;
            Arrays.fill(samples, 0);
            Catalano.Math.Tools.Permutate(perm);
            for (i4 = 0; i4 < N; ++i4) {
                samples[perm[i4]] = 1;
            }
            if (this.loss == Loss.Huber) {
                nodeOutput = new HuberNodeOutput(residual, response, 0.9);
            }
            this.trees[m] = new RegressionTree(this.attributes, this.J, order, samples, nodeOutput);
            this.trees[m].Learn(input, response);
            for (i4 = 0; i4 < n; ++i4) {
                int n2 = i4;
                residual[n2] = residual[n2] - this.shrinkage * this.trees[m].Predict(input[i4]);
                if (this.loss != Loss.LeastAbsoluteDeviation) continue;
                response[i4] = Math.signum(residual[i4]);
            }
        }
        this.importance = new double[this.attributes.length];
        for (RegressionTree tree : this.trees) {
            double[] imp = tree.getImportance();
            for (int i5 = 0; i5 < imp.length; ++i5) {
                int n3 = i5;
                this.importance[n3] = this.importance[n3] + imp[i5];
            }
        }
    }

    public double[] importance() {
        return this.importance;
    }

    public double getSamplingRate() {
        return this.f;
    }

    public int getNumLeaves() {
        return this.J;
    }

    public Loss getLossFunction() {
        return this.loss;
    }

    private int[][] sort(DecisionVariable[] attributes, double[][] x) {
        int n = x.length;
        int p = x[0].length;
        double[] a = new double[n];
        int[][] index = new int[p][];
        for (int j = 0; j < p; ++j) {
            if (attributes[j].type != DecisionVariable.Type.Continuous) continue;
            for (int i = 0; i < n; ++i) {
                a[i] = x[i][j];
            }
            index[j] = ArraysUtil.Argsort(a, true);
        }
        return index;
    }

    public int size() {
        return this.trees.length;
    }

    public void trim(int T) {
        if (T > this.trees.length) {
            throw new IllegalArgumentException("The new model size is larger than the current size.");
        }
        if (T <= 0) {
            throw new IllegalArgumentException("Invalid new model size: " + T);
        }
        if (T < this.trees.length) {
            this.trees = Arrays.copyOf(this.trees, T);
        }
    }

    @Override
    public double Predict(double[] feature) {
        double y = this.b;
        for (int i = 0; i < this.T; ++i) {
            y += this.shrinkage * this.trees[i].Predict(feature);
        }
        return y;
    }

    @Override
    public IRegression clone() {
        try {
            return (IRegression)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported: " + ex.getMessage());
        }
    }

    class HuberNodeOutput
    implements RegressionTree.NodeOutput {
        double[] residual;
        double[] response;
        double alpha;
        double delta;

        public HuberNodeOutput(double[] residual, double[] response, double alpha) {
            this.residual = residual;
            this.response = response;
            this.alpha = alpha;
            int n = residual.length;
            for (int i = 0; i < n; ++i) {
                response[i] = Math.abs(residual[i]);
            }
            int[] index = ArraysUtil.Argsort(response, true);
            this.delta = response[index[(int)((double)n * alpha)]];
            for (int i = 0; i < n; ++i) {
                response[i] = Math.abs(residual[i]) <= this.delta ? residual[i] : this.delta * Math.signum(residual[i]);
            }
        }

        @Override
        public double calculate(int[] samples) {
            int n = 0;
            for (int s : samples) {
                if (s <= 0) continue;
                ++n;
            }
            double[] res = new double[n];
            int j = 0;
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] <= 0) continue;
                res[j++] = this.residual[i];
            }
            double r = DescriptiveStatistics.Median(res);
            double output = 0.0;
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] <= 0) continue;
                double d = this.residual[i] - r;
                output += Math.signum(d) * Math.min(this.delta, Math.abs(d));
            }
            output = r + output / (double)n;
            return output;
        }
    }

    class LADNodeOutput
    implements RegressionTree.NodeOutput {
        double[] residual;

        public LADNodeOutput(double[] residual) {
            this.residual = residual;
        }

        @Override
        public double calculate(int[] samples) {
            int n = 0;
            for (int s : samples) {
                if (s <= 0) continue;
                ++n;
            }
            double[] r = new double[n];
            int j = 0;
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] <= 0) continue;
                r[j++] = this.residual[i];
            }
            return DescriptiveStatistics.Median(r);
        }
    }

    public static enum Loss {
        LeastSquares,
        LeastAbsoluteDeviation,
        Huber;

    }
}

