/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Regression;

import Catalano.Core.ArraysUtil;
import Catalano.MachineLearning.Dataset.DatasetRegression;
import Catalano.MachineLearning.Regression.IRegression;
import Catalano.Math.Distances.IDivergence;
import Catalano.Math.Distances.SquaredEuclideanDistance;
import Catalano.Statistics.Kernels.IMercerKernel;
import java.io.Serializable;

public class KNearestNeighbors
implements IRegression,
Serializable {
    private int k = 3;
    private double[][] input;
    private double[] output;
    private IDivergence divergence;
    private IMercerKernel kernel;

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public KNearestNeighbors() {
        this(3);
    }

    public KNearestNeighbors(int k) {
        this(k, new SquaredEuclideanDistance());
    }

    public KNearestNeighbors(int k, IDivergence divergence) {
        this.k = k;
        this.divergence = divergence;
    }

    public KNearestNeighbors(int k, IMercerKernel kernel) {
        this.k = k;
        this.kernel = kernel;
    }

    @Override
    public void Learn(DatasetRegression dataset) {
        this.Learn(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Learn(double[][] input, double[] output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public double Predict(double[] feature) {
        double[] temp;
        int i;
        double[] dist = new double[this.input.length];
        if (this.kernel == null) {
            for (i = 0; i < this.input.length; ++i) {
                temp = this.input[i];
                dist[i] = this.divergence.Compute(temp, feature);
            }
        } else {
            for (i = 0; i < this.input.length; ++i) {
                temp = this.input[i];
                dist[i] = this.kernel.Function(temp, feature);
            }
        }
        int[] indexes = ArraysUtil.Argsort(dist, true);
        double result = 0.0;
        for (int i2 = 0; i2 < this.k; ++i2) {
            result += this.output[indexes[i2]];
        }
        return result / (double)this.k;
    }

    @Override
    public IRegression clone() {
        try {
            return (IRegression)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported: " + ex.getMessage());
        }
    }
}

