/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.FeatureEncoder;

import Catalano.MachineLearning.FeatureEncoder.IFeatureEncoder;
import Catalano.MachineLearning.FeatureScaling.IFeatureScaling;
import Catalano.MachineLearning.FeatureScaling.VectorNormalization;
import Catalano.Math.Distances.Distance;

public class Vlad
implements IFeatureEncoder {
    private double[][] centroids;
    private boolean normalize;
    private boolean softmax;
    private IFeatureScaling scaleVlad;

    public Vlad(double[][] centroids) {
        this(centroids, true);
    }

    public Vlad(double[][] centroids, boolean normalize) {
        this(centroids, normalize, false);
    }

    public Vlad(double[][] centroids, boolean normalize, boolean softmax) {
        this(centroids, normalize, softmax, null);
    }

    public Vlad(double[][] centroids, boolean normalize, boolean softmax, IFeatureScaling scaleVlad) {
        this.centroids = centroids;
        this.normalize = normalize;
        this.scaleVlad = scaleVlad;
    }

    @Override
    public double[] Compute(double[][] features) {
        if (this.centroids == null) {
            throw new IllegalArgumentException("Centroids cant be null");
        }
        int k = this.centroids.length;
        int d = features[0].length;
        double[] result = new double[k * d];
        double[] current = new double[k * d];
        for (int f = 0; f < features.length; ++f) {
            int idx = 0;
            for (int c = 0; c < k; ++c) {
                for (int l = 0; l < d; ++l) {
                    current[idx++] = features[f][l] - this.centroids[c][l];
                }
            }
            if (this.softmax) {
                double[] dist = new double[this.centroids.length];
                for (int j = 0; j < this.centroids.length; ++j) {
                    dist[j] = Distance.Euclidean(features[f], this.centroids[j]);
                }
                dist = this.Softmax(dist, dist);
                idx = 0;
                for (int c = 0; c < k; ++c) {
                    for (int l = 0; l < d; ++l) {
                        int n = idx++;
                        current[n] = current[n] * dist[c];
                    }
                }
            }
            idx = 0;
            for (int i = 0; i < current.length; ++i) {
                int n = idx + i;
                result[n] = result[n] + current[i];
            }
        }
        if (this.scaleVlad != null) {
            result = this.scaleVlad.Compute(result);
        }
        if (this.normalize) {
            VectorNormalization vn = new VectorNormalization();
            result = vn.Compute(result);
        }
        return result;
    }

    private double[] Softmax(double[] input, double[] result) {
        int i;
        double sum = 0.0;
        for (i = 0; i < input.length; ++i) {
            double u;
            result[i] = u = Math.exp(input[i]);
            sum += u;
        }
        i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] / sum;
        }
        return result;
    }
}

