/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Exploration;

import Catalano.MachineLearning.Exploration.IExplorationPolicy;
import java.util.Arrays;

public class TabuSearchExploration
implements IExplorationPolicy {
    private int actions;
    private int[] tabuActions = null;
    private IExplorationPolicy basePolicy;

    public TabuSearchExploration(int actions, IExplorationPolicy basePolicy) {
        this.actions = actions;
        this.basePolicy = basePolicy;
        this.tabuActions = new int[actions];
    }

    public IExplorationPolicy getBasePolicy() {
        return this.basePolicy;
    }

    public void setBasePolicy(IExplorationPolicy basePolicy) {
        this.basePolicy = basePolicy;
    }

    @Override
    public int ChooseAction(double[] actionEstimates) {
        int nonTabuActions = this.actions;
        for (int i = 0; i < this.actions; ++i) {
            if (this.tabuActions[i] == 0) continue;
            --nonTabuActions;
        }
        double[] allowedActionEstimates = new double[nonTabuActions];
        int[] allowedActionMap = new int[nonTabuActions];
        int j = 0;
        for (int i = 0; i < this.actions; ++i) {
            if (this.tabuActions[i] == 0) {
                allowedActionEstimates[j] = actionEstimates[i];
                allowedActionMap[j] = i;
                ++j;
                continue;
            }
            int n = i;
            this.tabuActions[n] = this.tabuActions[n] - 1;
        }
        return allowedActionMap[this.basePolicy.ChooseAction(allowedActionEstimates)];
    }

    public void ResetTabuList() {
        Arrays.fill(this.tabuActions, 0, this.actions, 0);
    }
}

