/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Exploration;

import Catalano.MachineLearning.Exploration.IExplorationPolicy;
import java.util.Random;

public class EpsilonGreedyExploration
implements IExplorationPolicy {
    private double epsilon;
    private Random r = new Random();

    public EpsilonGreedyExploration(double epsilon) {
        this.epsilon = epsilon;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = Math.max(0.0, Math.min(1.0, epsilon));
    }

    @Override
    public int ChooseAction(double[] actionEstimates) {
        int actionsCount = actionEstimates.length;
        double maxReward = actionEstimates[0];
        int greedyAction = 0;
        for (int i = 1; i < actionsCount; ++i) {
            if (!(actionEstimates[i] > maxReward)) continue;
            maxReward = actionEstimates[i];
            greedyAction = i;
        }
        if (this.r.nextDouble() < this.epsilon) {
            int randomAction = this.r.nextInt(actionsCount - 1);
            if (randomAction >= greedyAction) {
                ++randomAction;
            }
            return randomAction;
        }
        return greedyAction;
    }
}

