/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Exploration;

import Catalano.MachineLearning.Exploration.IExplorationPolicy;
import java.util.Random;

public class BoltzmannExploration
implements IExplorationPolicy {
    double temperature;
    private Random r = new Random();

    public BoltzmannExploration(double temperature) {
        this.temperature = temperature;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Override
    public int ChooseAction(double[] actionEstimates) {
        int actionsCount = actionEstimates.length;
        double[] actionProbabilities = new double[actionsCount];
        double sum = 0.0;
        double probabilitiesSum = 0.0;
        for (int i = 0; i < actionsCount; ++i) {
            double actionProbability;
            actionProbabilities[i] = actionProbability = Math.exp(actionEstimates[i] / this.temperature);
            probabilitiesSum += actionProbability;
        }
        if (Double.isInfinite(probabilitiesSum) || probabilitiesSum == 0.0) {
            double maxReward = actionEstimates[0];
            int greedyAction = 0;
            for (int i = 1; i < actionsCount; ++i) {
                if (!(actionEstimates[i] > maxReward)) continue;
                maxReward = actionEstimates[i];
                greedyAction = i;
            }
            return greedyAction;
        }
        double actionRandomNumber = this.r.nextDouble();
        for (int i = 0; i < actionsCount; ++i) {
            if (!(actionRandomNumber <= (sum += actionProbabilities[i] / probabilitiesSum))) continue;
            return i;
        }
        return actionsCount - 1;
    }
}

