/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Codification {
    private String[] columnNames;
    private String[][] labels;
    private List<HashMap<String, Integer>> lst;

    public void setData(String columnName, String[] labels) {
        this.columnNames = new String[]{columnName};
        this.labels = new String[labels.length][1];
        for (int i = 0; i < labels.length; ++i) {
            this.labels[i][0] = labels[i];
        }
        this.Map(this.labels);
    }

    public void setData(String[] columnNames, String[][] labels) {
        if (columnNames.length != labels[0].length) {
            throw new IllegalArgumentException("The size of column names must be the same size of number of columns of labels.");
        }
        this.columnNames = columnNames;
        this.labels = labels;
        this.Map(labels);
    }

    public Codification(String columnName, String[] labels) {
        this.setData(columnName, labels);
    }

    public Codification(String[] columnNames, String[][] labels) {
        this.setData(columnNames, labels);
    }

    private void Map(String[][] labels) {
        this.lst = new ArrayList<HashMap<String, Integer>>();
        for (int j = 0; j < labels[0].length; ++j) {
            int idx = 0;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i = 0; i < labels.length; ++i) {
                if (map.containsKey(labels[i][j])) continue;
                map.put(labels[i][j], idx++);
            }
            this.lst.add(map);
        }
    }

    public int[] Translate(String columnName, String[] labels) {
        int[] symbols = new int[labels.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (this.columnNames[i].equals(columnName)) {
                for (int k = 0; k < symbols.length; ++k) {
                    symbols[k] = this.lst.get(i).get(labels[k]);
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid column name.");
        }
        return symbols;
    }

    public int Translate(String columnName, String name) {
        int i = 0;
        if (i < this.columnNames.length) {
            if (this.columnNames[i].equals(columnName)) {
                return this.lst.get(i).get(name);
            }
            throw new IllegalArgumentException("Invalid column name.");
        }
        return -1;
    }

    public String getName(String columnName, int symbol) {
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (this.columnNames[i].equals(columnName)) {
                for (Map.Entry<String, Integer> m : this.lst.get(i).entrySet()) {
                    if (m.getValue() != symbol) continue;
                    return m.getKey();
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid column name.");
        }
        return null;
    }
}

