/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Classification;

import Catalano.Core.Concurrent.MulticoreExecutor;
import Catalano.Core.Structs.DoubleArrayList;
import Catalano.MachineLearning.Classification.SVM;
import Catalano.Math.Matrix;
import Catalano.Math.SparseArray;
import Catalano.Math.Tools;
import Catalano.Statistics.Kernels.IMercerKernel;
import Catalano.Statistics.Kernels.Linear;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;

public class SVM<T>
implements Serializable {
    private static final double TAU = 1.0E-12;
    private LASVM svm;
    private List<LASVM> svms;
    private IMercerKernel kernel;
    private int p;
    private int k;
    private Strategy strategy = Strategy.ONE_VS_ONE;
    private double[] wi;
    private double tol = 0.001;

    public SVM(IMercerKernel kernel, double C) {
        this(kernel, C, C);
    }

    public SVM(IMercerKernel kernel, double Cp, double Cn) {
        if (Cp < 0.0) {
            throw new IllegalArgumentException("Invalid postive instance soft margin penalty: " + Cp);
        }
        if (Cn < 0.0) {
            throw new IllegalArgumentException("Invalid negative instance soft margin penalty: " + Cn);
        }
        this.kernel = kernel;
        this.k = 2;
        this.svm = new LASVM(Cp, Cn);
    }

    public SVM(IMercerKernel kernel, double C, int k, Strategy strategy) {
        if (C < 0.0) {
            throw new IllegalArgumentException("Invalid soft margin penalty: " + C);
        }
        if (k < 3) {
            throw new IllegalArgumentException("Invalid number of classes: " + k);
        }
        this.kernel = kernel;
        this.k = k;
        this.strategy = strategy;
        if (strategy == Strategy.ONE_VS_ALL) {
            this.svms = new ArrayList<LASVM>(k);
            for (int i = 0; i < k; ++i) {
                this.svms.add(new LASVM(C, C));
            }
        } else {
            this.svms = new ArrayList<LASVM>(k * (k - 1) / 2);
            for (int i = 0; i < k; ++i) {
                for (int j = i + 1; j < k; ++j) {
                    this.svms.add(new LASVM(C, C));
                }
            }
        }
    }

    public SVM(IMercerKernel kernel, double C, double[] weight, Strategy strategy) {
        int i;
        if (C < 0.0) {
            throw new IllegalArgumentException("Invalid soft margin penalty: " + C);
        }
        if (weight.length < 3) {
            throw new IllegalArgumentException("Invalid number of classes: " + weight.length);
        }
        for (i = 0; i < weight.length; ++i) {
            if (!(weight[i] <= 0.0)) continue;
            throw new IllegalArgumentException("Invalid class weight: " + weight[i]);
        }
        this.kernel = kernel;
        this.k = weight.length;
        this.strategy = strategy;
        this.wi = weight;
        if (strategy == Strategy.ONE_VS_ALL) {
            this.svms = new ArrayList<LASVM>(this.k);
            for (i = 0; i < this.k; ++i) {
                this.svms.add(new LASVM(C, C));
            }
        } else {
            this.svms = new ArrayList<LASVM>(this.k * (this.k - 1) / 2);
            for (i = 0; i < this.k; ++i) {
                for (int j = i + 1; j < this.k; ++j) {
                    this.svms.add(new LASVM(weight[i] * C, weight[j] * C));
                }
            }
        }
    }

    public void setTolerance(double tol) {
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invlaid tolerance of convergence test:" + tol);
        }
        this.tol = tol;
    }

    public void Learn(T x, int y) {
        this.Learn(x, y, 1.0);
    }

    public void Learn(T x, int y, double weight) {
        if (y < 0 || y >= this.k) {
            throw new IllegalArgumentException("Invalid label");
        }
        if (weight <= 0.0) {
            throw new IllegalArgumentException("Invalid instance weight: " + weight);
        }
        if (this.k == 2) {
            if (y == 1) {
                this.svm.process(x, 1, weight);
            } else {
                this.svm.process(x, -1, weight);
            }
        } else if (this.strategy == Strategy.ONE_VS_ALL) {
            if (this.wi != null) {
                weight *= this.wi[y];
            }
            for (int i = 0; i < this.k; ++i) {
                if (y == i) {
                    this.svms.get(i).process(x, 1, weight);
                    continue;
                }
                this.svms.get(i).process(x, -1, weight);
            }
        } else {
            int m = 0;
            for (int i = 0; i < this.k; ++i) {
                int j = i + 1;
                while (j < this.k) {
                    if (y == i) {
                        this.svms.get(m).process(x, 1, weight);
                    } else if (y == j) {
                        this.svms.get(m).process(x, -1, weight);
                    }
                    ++j;
                    ++m;
                }
            }
        }
    }

    public void Learn(T[] x, int[] y) {
        this.Learn(x, y, null);
    }

    public void Learn(T[] x, int[] y, double[] weight) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (weight != null && x.length != weight.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and instance weight don't match: %d != %d", x.length, weight.length));
        }
        int miny = Matrix.Min(y);
        if (miny < 0) {
            throw new IllegalArgumentException("Negative class label:" + miny);
        }
        int maxy = Matrix.Max(y);
        if (maxy >= this.k) {
            throw new IllegalArgumentException("Invalid class label:" + maxy);
        }
        if (this.k == 2) {
            int[] yi = new int[y.length];
            for (int i = 0; i < y.length; ++i) {
                yi[i] = y[i] == 1 ? 1 : -1;
            }
            if (weight == null) {
                this.svm.learn(x, yi);
            } else {
                this.svm.learn(x, yi, weight);
            }
        } else if (this.strategy == Strategy.ONE_VS_ALL) {
            ArrayList<TrainingTask> tasks = new ArrayList<TrainingTask>(this.k);
            for (int i = 0; i < this.k; ++i) {
                int[] yi = new int[y.length];
                double[] w = this.wi == null ? weight : new double[y.length];
                for (int l = 0; l < y.length; ++l) {
                    yi[l] = y[l] == i ? 1 : -1;
                    if (this.wi == null) continue;
                    w[l] = this.wi[y[l]];
                    if (weight == null) continue;
                    int n = l;
                    w[n] = w[n] * weight[l];
                }
                tasks.add(new TrainingTask(this.svms.get(i), x, yi, w));
            }
            try {
                MulticoreExecutor.run(tasks);
            }
            catch (Exception i) {}
        } else {
            ArrayList<TrainingTask> tasks = new ArrayList<TrainingTask>(this.k * (this.k - 1) / 2);
            int m = 0;
            for (int i = 0; i < this.k; ++i) {
                int j = i + 1;
                while (j < this.k) {
                    int n = 0;
                    for (int l = 0; l < y.length; ++l) {
                        if (y[l] != i && y[l] != j) continue;
                        ++n;
                    }
                    Object[] xij = (Object[])Array.newInstance(x.getClass().getComponentType(), n);
                    int[] yij = new int[n];
                    double[] wij = weight == null ? null : new double[n];
                    int q = 0;
                    for (int l = 0; l < y.length; ++l) {
                        if (y[l] == i) {
                            xij[q] = x[l];
                            yij[q] = 1;
                            if (weight != null) {
                                wij[q] = weight[l];
                            }
                            ++q;
                            continue;
                        }
                        if (y[l] != j) continue;
                        xij[q] = x[l];
                        yij[q] = -1;
                        if (weight != null) {
                            wij[q] = weight[l];
                        }
                        ++q;
                    }
                    tasks.add(new TrainingTask(this.svms.get(m), xij, yij, wij));
                    ++j;
                    ++m;
                }
            }
            try {
                MulticoreExecutor.run(tasks);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void Finish() {
        if (this.k == 2) {
            this.svm.finish();
        } else {
            ArrayList<ProcessTask> tasks = new ArrayList<ProcessTask>(this.svms.size());
            for (LASVM s : this.svms) {
                tasks.add(new ProcessTask(s));
            }
            try {
                MulticoreExecutor.run(tasks);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public int Predict(T x) {
        if (this.k == 2) {
            if (this.svm.predict(x) > 0.0) {
                return 1;
            }
            return 0;
        }
        if (this.strategy == Strategy.ONE_VS_ALL) {
            int label = 0;
            double maxf = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.svms.size(); ++i) {
                double f = this.svms.get(i).predict(x);
                if (!(f > maxf)) continue;
                label = i;
                maxf = f;
            }
            return label;
        }
        int[] count = new int[this.k];
        int m = 0;
        for (int i = 0; i < this.k; ++i) {
            int j = i + 1;
            while (j < this.k) {
                double f = this.svms.get(m).predict(x);
                if (f > 0.0) {
                    int n = i;
                    count[n] = count[n] + 1;
                } else {
                    int n = j;
                    count[n] = count[n] + 1;
                }
                ++j;
                ++m;
            }
        }
        int max = 0;
        int label = 0;
        for (int i = 0; i < this.k; ++i) {
            if (count[i] <= max) continue;
            max = count[i];
            label = i;
        }
        return label;
    }

    class ProcessTask
    implements Callable<LASVM> {
        LASVM svm;

        ProcessTask(LASVM svm) {
            this.svm = svm;
        }

        @Override
        public LASVM call() {
            this.svm.finish();
            return this.svm;
        }
    }

    class TrainingTask
    implements Callable<LASVM> {
        LASVM svm;
        T[] x;
        int[] y;
        double[] weight;

        TrainingTask(LASVM svm, T[] x, int[] y, double[] weight) {
            this.svm = svm;
            this.x = x;
            this.y = y;
            this.weight = weight;
        }

        @Override
        public LASVM call() {
            this.svm.learn(this.x, this.y, this.weight);
            return this.svm;
        }
    }

    final class LASVM
    implements Serializable {
        private double Cp = 1.0;
        private double Cn = 1.0;
        List<Catalano.MachineLearning.Classification.SVM$LASVM.SupportVector> sv = new ArrayList<Catalano.MachineLearning.Classification.SVM$LASVM.SupportVector>();
        double[] w;
        double b = 0.0;
        int nsv = 0;
        int nbsv = 0;
        transient boolean minmaxflag = false;
        transient Catalano.MachineLearning.Classification.SVM$LASVM.SupportVector svmin = null;
        transient Catalano.MachineLearning.Classification.SVM$LASVM.SupportVector svmax = null;
        transient double gmin = Double.MAX_VALUE;
        transient double gmax = -1.7976931348623157E308;

        LASVM(double Cp, double Cn) {
            this.Cp = Cp;
            this.Cn = Cn;
        }

        void learn(T[] x, int[] y) {
            this.learn(x, y, null);
        }

        /*
         * WARNING - void declaration
         */
        void learn(T[] x, int[] y, double[] weight) {
            if (SVM.this.p == 0 && SVM.this.kernel instanceof Linear) {
                Object[] x0;
                if (x instanceof double[][]) {
                    x0 = (double[])x[0];
                    SVM.this.p = x0.length;
                } else if (x instanceof float[][]) {
                    x0 = (float[])x[0];
                    SVM.this.p = x0.length;
                } else {
                    throw new UnsupportedOperationException("Unsupported data type for linear kernel.");
                }
            }
            int c1 = 0;
            int c2 = 0;
            for (SupportVector supportVector : this.sv) {
                if (supportVector == null) continue;
                if (supportVector.y > 0) {
                    ++c1;
                    continue;
                }
                if (supportVector.y >= 0) continue;
                ++c2;
            }
            int n = x.length;
            if (c1 < 5 || c2 < 5) {
                void var7_11;
                boolean bl = false;
                while (var7_11 < n) {
                    if (y[var7_11] == 1 && c1 < 5) {
                        if (weight == null) {
                            this.process(x[var7_11], y[var7_11]);
                        } else {
                            this.process(x[var7_11], y[var7_11], weight[var7_11]);
                        }
                        ++c1;
                    }
                    if (y[var7_11] == -1 && c2 < 5) {
                        if (weight == null) {
                            this.process(x[var7_11], y[var7_11]);
                        } else {
                            this.process(x[var7_11], y[var7_11], weight[var7_11]);
                        }
                        ++c2;
                    }
                    if (c1 >= 5 && c2 >= 5) break;
                    ++var7_11;
                }
            }
            int[] nArray = Tools.Random().permutate(n);
            for (int i = 0; i < n; ++i) {
                if (weight == null) {
                    this.process(x[nArray[i]], y[nArray[i]]);
                } else {
                    this.process(x[nArray[i]], y[nArray[i]], weight[nArray[i]]);
                }
                do {
                    this.reprocess(SVM.this.tol);
                    this.minmax();
                } while (this.gmax - this.gmin > 1000.0);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        double predict(T x) {
            double f = this.b;
            if (SVM.this.kernel instanceof Linear && this.w != null) {
                if (x instanceof double[]) {
                    f += Matrix.InnerProduct(this.w, (double[])x);
                    return f;
                } else {
                    if (!(x instanceof SparseArray)) throw new UnsupportedOperationException("Unsupported data type for linear kernel");
                    for (SparseArray.Entry entry : (SparseArray)x) {
                        f += this.w[entry.i] * entry.x;
                    }
                }
                return f;
            } else {
                for (SupportVector supportVector : this.sv) {
                    if (supportVector == null) continue;
                    f += supportVector.alpha * SVM.this.kernel.Function(supportVector.x, x);
                }
            }
            return f;
        }

        void minmax() {
            if (!this.minmaxflag) {
                this.gmin = Double.MAX_VALUE;
                this.gmax = -1.7976931348623157E308;
                for (SupportVector supportVector : this.sv) {
                    if (supportVector == null) continue;
                    double gi = supportVector.g;
                    double ai = supportVector.alpha;
                    if (gi < this.gmin && ai > supportVector.cmin) {
                        this.svmin = supportVector;
                        this.gmin = gi;
                    }
                    if (!(gi > this.gmax) || !(ai < supportVector.cmax)) continue;
                    this.svmax = supportVector;
                    this.gmax = gi;
                }
                this.minmaxflag = true;
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        boolean smo(SupportVector v1, SupportVector v2, double epsgr) {
            double ostep;
            double step;
            double curv;
            if (v1 == null || v2 == null) {
                double gain;
                double mu;
                double k;
                double Z;
                SupportVector v;
                int i;
                double best;
                double gm;
                double km;
                if (v1 == null && v2 == null) {
                    this.minmax();
                    if (this.gmax > -this.gmin) {
                        v2 = this.svmax;
                    } else {
                        v1 = this.svmin;
                    }
                }
                if (v2 == null) {
                    if (v1.kcache == null) {
                        v1.kcache = new DoubleArrayList(this.sv.size());
                        for (SupportVector supportVector : this.sv) {
                            if (supportVector != null) {
                                v1.kcache.add(SVM.this.kernel.Function(v1.x, supportVector.x));
                                continue;
                            }
                            v1.kcache.add(0.0);
                        }
                    }
                    km = v1.k;
                    gm = v1.g;
                    best = 0.0;
                    for (i = 0; i < this.sv.size(); ++i) {
                        v = (SupportVector)this.sv.get(i);
                        if (v == null) continue;
                        Z = v.g - gm;
                        k = v1.kcache.get(i);
                        double curv2 = km + v.k - 2.0 * k;
                        if (curv2 <= 0.0) {
                            curv2 = 1.0E-12;
                        }
                        if (!((mu = Z / curv2) > 0.0 && v.alpha < v.cmax) && (!(mu < 0.0) || !(v.alpha > v.cmin)) || !((gain = Z * mu) > best)) continue;
                        best = gain;
                        v2 = v;
                    }
                } else {
                    if (v2.kcache == null) {
                        v2.kcache = new DoubleArrayList(this.sv.size());
                        for (SupportVector supportVector : this.sv) {
                            if (supportVector != null) {
                                v2.kcache.add(SVM.this.kernel.Function(v2.x, supportVector.x));
                                continue;
                            }
                            v2.kcache.add(0.0);
                        }
                    }
                    km = v2.k;
                    gm = v2.g;
                    best = 0.0;
                    for (i = 0; i < this.sv.size(); ++i) {
                        v = (SupportVector)this.sv.get(i);
                        if (v == null) continue;
                        Z = gm - v.g;
                        k = v2.kcache.get(i);
                        double curv2 = km + v.k - 2.0 * k;
                        if (curv2 <= 0.0) {
                            curv2 = 1.0E-12;
                        }
                        if (!((mu = Z / curv2) > 0.0 && v.alpha > v.cmin) && (!(mu < 0.0) || !(v.alpha < v.cmax)) || !((gain = Z * mu) > best)) continue;
                        best = gain;
                        v1 = v;
                    }
                }
            }
            if (v1 == null || v2 == null) {
                return false;
            }
            if (v1.kcache == null) {
                v1.kcache = new DoubleArrayList(this.sv.size());
                for (SupportVector supportVector : this.sv) {
                    if (supportVector != null) {
                        v1.kcache.add(SVM.this.kernel.Function(v1.x, supportVector.x));
                        continue;
                    }
                    v1.kcache.add(0.0);
                }
            }
            if (v2.kcache == null) {
                v2.kcache = new DoubleArrayList(this.sv.size());
                for (SupportVector supportVector : this.sv) {
                    if (supportVector != null) {
                        v2.kcache.add(SVM.this.kernel.Function(v2.x, supportVector.x));
                        continue;
                    }
                    v2.kcache.add(0.0);
                }
            }
            if ((curv = v1.k + v2.k - 2.0 * SVM.this.kernel.Function(v1.x, v2.x)) <= 0.0) {
                curv = 1.0E-12;
            }
            if ((step = (v2.g - v1.g) / curv) >= 0.0) {
                ostep = v1.alpha - v1.cmin;
                if (ostep < step) {
                    step = ostep;
                }
                if ((ostep = v2.cmax - v2.alpha) < step) {
                    step = ostep;
                }
            } else {
                ostep = v2.cmin - v2.alpha;
                if (ostep > step) {
                    step = ostep;
                }
                if ((ostep = v1.alpha - v1.cmax) > step) {
                    step = ostep;
                }
            }
            v1.alpha -= step;
            v2.alpha += step;
            for (int i = 0; i < this.sv.size(); ++i) {
                SupportVector v = (SupportVector)this.sv.get(i);
                if (v == null) continue;
                v.g -= step * (v2.kcache.get(i) - v1.kcache.get(i));
            }
            this.minmaxflag = false;
            this.minmax();
            this.b = (this.gmax + this.gmin) / 2.0;
            return !(this.gmax - this.gmin < epsgr);
        }

        boolean process(T x, int y) {
            return this.process(x, y, 1.0);
        }

        /*
         * WARNING - void declaration
         */
        boolean process(T x, int y, double weight) {
            SupportVector v1;
            void var9_9;
            if (y != 1 && y != -1) {
                throw new IllegalArgumentException("Invalid label: " + y);
            }
            if (weight <= 0.0) {
                throw new IllegalArgumentException("Invalid instance weight: " + weight);
            }
            double g = y;
            DoubleArrayList kcache = new DoubleArrayList(this.sv.size() + 1);
            if (this.sv.size() > 0) {
                for (SupportVector supportVector : this.sv) {
                    if (supportVector != null) {
                        if (supportVector.x == x) {
                            return true;
                        }
                        double k = SVM.this.kernel.Function(supportVector.x, x);
                        g -= supportVector.alpha * k;
                        kcache.add(k);
                        continue;
                    }
                    kcache.add(0.0);
                }
                this.minmax();
                if (this.gmin < this.gmax && (y > 0 && g < this.gmin || y < 0 && g > this.gmax)) {
                    return false;
                }
            }
            SupportVector v = new SupportVector();
            v.x = x;
            v.y = y;
            v.alpha = 0.0;
            v.g = g;
            v.k = SVM.this.kernel.Function(x, x);
            v.kcache = kcache;
            if (y > 0) {
                v.cmin = 0.0;
                v.cmax = weight * this.Cp;
            } else {
                v.cmin = -weight * this.Cn;
                v.cmax = 0.0;
            }
            int n = this.sv.size();
            while (var9_9 < this.sv.size()) {
                if (this.sv.get((int)var9_9) == null) {
                    this.sv.set((int)var9_9, (Catalano.MachineLearning.Classification.SVM$LASVM.SupportVector)v);
                    kcache.set((int)var9_9, v.k);
                    for (int j = 0; j < this.sv.size(); ++j) {
                        v1 = (SupportVector)this.sv.get(j);
                        if (v1 == null || v1.kcache == null) continue;
                        v1.kcache.set((int)var9_9, kcache.get(j));
                    }
                    break;
                }
                ++var9_9;
            }
            if (var9_9 >= this.sv.size()) {
                for (int j = 0; j < this.sv.size(); ++j) {
                    v1 = (SupportVector)this.sv.get(j);
                    if (v1 == null || v1.kcache == null) continue;
                    v1.kcache.add(kcache.get(j));
                }
                v.kcache.add(v.k);
                this.sv.add((Catalano.MachineLearning.Classification.SVM$LASVM.SupportVector)v);
            }
            if (y > 0) {
                this.smo(null, v, 0.0);
            } else {
                this.smo(v, null, 0.0);
            }
            this.minmaxflag = false;
            return true;
        }

        boolean reprocess(double epsgr) {
            boolean status = this.smo(null, null, epsgr);
            this.evict();
            return status;
        }

        void finish() {
            this.finish(SVM.this.tol);
        }

        void finish(double epsgr) {
            int count = 1;
            while (this.smo(null, null, epsgr)) {
                if (count % 1000 == 0) {
                    // empty if block
                }
                ++count;
            }
            Iterator<Catalano.MachineLearning.Classification.SVM$LASVM.SupportVector> iter = this.sv.iterator();
            while (iter.hasNext()) {
                SupportVector v = (SupportVector)iter.next();
                if (v == null) {
                    iter.remove();
                    continue;
                }
                if (v.alpha != 0.0 || !(v.g >= this.gmax && 0.0 >= v.cmax) && (!(v.g <= this.gmin) || !(0.0 <= v.cmin))) continue;
                iter.remove();
            }
            this.cleanup();
            if (SVM.this.kernel instanceof Linear) {
                this.w = new double[SVM.this.p];
                for (SupportVector supportVector : this.sv) {
                    int i;
                    Object[] x;
                    if (supportVector.x instanceof double[]) {
                        x = (double[])supportVector.x;
                        for (i = 0; i < this.w.length; ++i) {
                            int n = i;
                            this.w[n] = this.w[n] + supportVector.alpha * x[i];
                        }
                        continue;
                    }
                    if (supportVector.x instanceof int[]) {
                        x = (int[])supportVector.x;
                        for (i = 0; i < x.length; ++i) {
                            double d = x[i];
                            this.w[d] = this.w[d] + supportVector.alpha;
                        }
                        continue;
                    }
                    if (!(supportVector.x instanceof SparseArray)) continue;
                    for (SparseArray.Entry e : (SparseArray)supportVector.x) {
                        int n = e.i;
                        this.w[n] = this.w[n] + supportVector.alpha * e.x;
                    }
                }
            }
        }

        void evict() {
            this.minmax();
            for (int i = 0; i < this.sv.size(); ++i) {
                SupportVector v = (SupportVector)this.sv.get(i);
                if (v == null || v.alpha != 0.0 || !(v.g >= this.gmax && 0.0 >= v.cmax) && (!(v.g <= this.gmin) || !(0.0 <= v.cmin))) continue;
                this.sv.set(i, null);
            }
        }

        void cleanup() {
            this.nsv = 0;
            this.nbsv = 0;
            for (SupportVector supportVector : this.sv) {
                if (supportVector == null) continue;
                ++this.nsv;
                supportVector.kcache = null;
                if (supportVector.alpha != supportVector.cmin && supportVector.alpha != supportVector.cmax) continue;
                ++this.nbsv;
            }
        }

        class SupportVector
        implements Serializable {
            T x;
            int y;
            double alpha;
            double g;
            double cmin;
            double cmax;
            double k;
            DoubleArrayList kcache;

            SupportVector() {
            }
        }
    }

    public static enum Strategy {
        ONE_VS_ONE,
        ONE_VS_ALL;

    }
}

