/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Classification.DecisionTrees.Learning;

import Catalano.Core.ArraysUtil;
import Catalano.MachineLearning.Classification.IClassifier;
import Catalano.MachineLearning.Dataset.DatasetClassification;
import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.Regression.RegressionTrees.RegressionTree;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;
import Catalano.Statistics.DescriptiveStatistics;
import java.io.Serializable;
import java.util.Arrays;

public class GradientBoostingTree
implements IClassifier,
Serializable {
    private DecisionVariable[] attributes;
    private int k = 2;
    private RegressionTree[] trees;
    private RegressionTree[][] forest;
    private double[] importance;
    private double b = 0.0;
    private double shrinkage = 0.005;
    private int J = 6;
    private int T = 500;
    private double f = 0.7;

    public double[] getImportance() {
        return this.importance;
    }

    public GradientBoostingTree() {
        this(500);
    }

    public GradientBoostingTree(int T) {
        this(T, 6);
    }

    public GradientBoostingTree(int T, int J) {
        this(T, J, 0.005);
    }

    public GradientBoostingTree(int T, int J, double shrinkage) {
        this(T, J, shrinkage, 0.7);
    }

    public GradientBoostingTree(int T, int J, double shrinkage, double f) {
        this(null, T, J, shrinkage, f);
    }

    public GradientBoostingTree(DecisionVariable[] attributes) {
        this(attributes, 500);
    }

    public GradientBoostingTree(DecisionVariable[] attributes, int T) {
        this(attributes, T, 6);
    }

    public GradientBoostingTree(DecisionVariable[] attributes, int T, int J) {
        this(attributes, T, J, 0.005);
    }

    public GradientBoostingTree(DecisionVariable[] attributes, int T, int J, double shrinkage) {
        this(attributes, T, J, shrinkage, 0.7);
    }

    public GradientBoostingTree(DecisionVariable[] attributes, int T, int J, double shrinkage, double f) {
        this.attributes = attributes;
        this.T = T;
        this.J = J;
        this.shrinkage = shrinkage;
        this.f = f;
    }

    @Override
    public void Learn(DatasetClassification dataset) {
        this.Learn(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Learn(double[][] input, int[] output) {
        if (input.length != output.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", input.length, output.length));
        }
        if (this.shrinkage <= 0.0 || this.shrinkage > 1.0) {
            throw new IllegalArgumentException("Invalid shrinkage: " + this.shrinkage);
        }
        if (this.f <= 0.0 || this.f > 1.0) {
            throw new IllegalArgumentException("Invalid sampling fraction: " + this.f);
        }
        if (this.attributes == null) {
            int p = input[0].length;
            this.attributes = new DecisionVariable[p];
            for (int i = 0; i < p; ++i) {
                this.attributes[i] = new DecisionVariable("F" + i);
            }
        }
        this.k = Matrix.Max(output) + 1;
        if (this.k < 2) {
            throw new IllegalArgumentException("Only one class or negative class labels.");
        }
        this.importance = new double[this.attributes.length];
        if (this.k == 2) {
            this.train2(this.attributes, input, output);
            for (RegressionTree tree : this.trees) {
                double[] imp = tree.getImportance();
                for (int i = 0; i < imp.length; ++i) {
                    int n = i;
                    this.importance[n] = this.importance[n] + imp[i];
                }
            }
        } else {
            this.traink(this.attributes, input, output);
            RegressionTree[][] regressionTreeArray = this.forest;
            int n = regressionTreeArray.length;
            for (int i = 0; i < n; ++i) {
                RegressionTree[] grove;
                for (RegressionTree tree : grove = regressionTreeArray[i]) {
                    double[] imp = tree.getImportance();
                    for (int i2 = 0; i2 < imp.length; ++i2) {
                        int n2 = i2;
                        this.importance[n2] = this.importance[n2] + imp[i2];
                    }
                }
            }
        }
    }

    private void train2(DecisionVariable[] attributes, double[][] x, int[] y) {
        int n = x.length;
        int N = (int)Math.round((double)n * this.f);
        int[] y2 = new int[n];
        for (int i = 0; i < n; ++i) {
            y2[i] = y[i] == 1 ? 1 : -1;
        }
        y = y2;
        double[] h = new double[n];
        double[] response = new double[n];
        double mu = DescriptiveStatistics.Mean(y);
        this.b = 0.5 * Math.log((1.0 + mu) / (1.0 - mu));
        for (int i = 0; i < n; ++i) {
            h[i] = this.b;
        }
        int[][] order = this.sort(attributes, x);
        L2NodeOutput output = new L2NodeOutput(response);
        this.trees = new RegressionTree[this.T];
        int[] perm = new int[n];
        int[] samples = new int[n];
        for (int i = 0; i < n; ++i) {
            perm[i] = i;
        }
        for (int m = 0; m < this.T; ++m) {
            int i;
            Arrays.fill(samples, 0);
            Tools.Permutate(perm);
            for (i = 0; i < N; ++i) {
                samples[perm[i]] = 1;
            }
            for (i = 0; i < n; ++i) {
                response[i] = 2.0 * (double)y[i] / (1.0 + Math.exp((double)(2 * y[i]) * h[i]));
            }
            this.trees[m] = new RegressionTree(attributes, this.J, order, samples, output);
            this.trees[m].Learn(x, response);
            for (i = 0; i < n; ++i) {
                int n2 = i;
                h[n2] = h[n2] + this.shrinkage * this.trees[m].Predict(x[i]);
            }
        }
    }

    private void traink(DecisionVariable[] attributes, double[][] x, int[] y) {
        int n = x.length;
        int N = (int)Math.round((double)n * this.f);
        double[][] h = new double[this.k][n];
        double[][] p = new double[this.k][n];
        double[][] response = new double[this.k][n];
        int[][] order = this.sort(attributes, x);
        this.forest = new RegressionTree[this.k][this.T];
        LKNodeOutput[] output = new LKNodeOutput[this.k];
        for (int i = 0; i < this.k; ++i) {
            output[i] = new LKNodeOutput(response[i]);
        }
        int[] perm = new int[n];
        int[] samples = new int[n];
        for (int i = 0; i < n; ++i) {
            perm[i] = i;
        }
        for (int m = 0; m < this.T; ++m) {
            for (int i = 0; i < n; ++i) {
                int j;
                double max = Double.NEGATIVE_INFINITY;
                for (int j2 = 0; j2 < this.k; ++j2) {
                    if (!(max < h[j2][i])) continue;
                    max = h[j2][i];
                }
                double Z = 0.0;
                for (j = 0; j < this.k; ++j) {
                    p[j][i] = Math.exp(h[j][i] - max);
                    Z += p[j][i];
                }
                for (j = 0; j < this.k; ++j) {
                    double[] dArray = p[j];
                    int n2 = i;
                    dArray[n2] = dArray[n2] / Z;
                }
            }
            for (int j = 0; j < this.k; ++j) {
                int i;
                for (i = 0; i < n; ++i) {
                    response[j][i] = y[i] == j ? 1.0 : 0.0;
                    double[] dArray = response[j];
                    int n3 = i;
                    dArray[n3] = dArray[n3] - p[j][i];
                }
                Arrays.fill(samples, 0);
                Tools.Permutate(perm);
                for (i = 0; i < N; ++i) {
                    samples[perm[i]] = 1;
                }
                this.forest[j][m] = new RegressionTree(attributes, this.J, order, samples, output[j]);
                this.forest[j][m].Learn(x, response[j]);
                for (i = 0; i < n; ++i) {
                    double[] dArray = h[j];
                    int n4 = i;
                    dArray[n4] = dArray[n4] + this.shrinkage * this.forest[j][m].Predict(x[i]);
                }
            }
        }
    }

    public int size() {
        return this.trees.length;
    }

    public void trim(int T) {
        if (this.k == 2) {
            if (T > this.trees.length) {
                throw new IllegalArgumentException("The new model size is larger than the current size.");
            }
            if (T <= 0) {
                throw new IllegalArgumentException("Invalid new model size: " + T);
            }
            if (T < this.trees.length) {
                this.trees = Arrays.copyOf(this.trees, T);
            }
        } else {
            if (T > this.forest[0].length) {
                throw new IllegalArgumentException("The new model size is larger than the current one.");
            }
            if (T <= 0) {
                throw new IllegalArgumentException("Invalid new model size: " + T);
            }
            if (T < this.forest[0].length) {
                for (int i = 0; i < this.forest.length; ++i) {
                    this.forest[i] = Arrays.copyOf(this.forest[i], T);
                }
            }
        }
    }

    private int[][] sort(DecisionVariable[] attributes, double[][] x) {
        int n = x.length;
        int p = x[0].length;
        double[] a = new double[n];
        int[][] index = new int[p][];
        for (int j = 0; j < p; ++j) {
            if (attributes[j].type != DecisionVariable.Type.Continuous) continue;
            for (int i = 0; i < n; ++i) {
                a[i] = x[i][j];
            }
            index[j] = ArraysUtil.Argsort(a, true);
        }
        return index;
    }

    @Override
    public int Predict(double[] x) {
        if (this.k == 2) {
            double y = this.b;
            for (int i = 0; i < this.T; ++i) {
                y += this.shrinkage * this.trees[i].Predict(x);
            }
            return y > 0.0 ? 1 : 0;
        }
        double max = Double.NEGATIVE_INFINITY;
        int y = -1;
        for (int j = 0; j < this.k; ++j) {
            double yj = 0.0;
            for (int i = 0; i < this.T; ++i) {
                yj += this.shrinkage * this.forest[j][i].Predict(x);
            }
            if (!(yj > max)) continue;
            max = yj;
            y = j;
        }
        return y;
    }

    public int Predict(double[] x, double[] posteriori) {
        int i;
        if (posteriori.length != this.k) {
            throw new IllegalArgumentException(String.format("Invalid posteriori vector size: %d, expected: %d", posteriori.length, this.k));
        }
        if (this.k == 2) {
            double y = this.b;
            for (int i2 = 0; i2 < this.T; ++i2) {
                y += this.shrinkage * this.trees[i2].Predict(x);
            }
            posteriori[0] = 1.0 / (1.0 + Math.exp(2.0 * y));
            posteriori[1] = 1.0 - posteriori[0];
            if (y > 0.0) {
                return 1;
            }
            return 0;
        }
        double max = Double.NEGATIVE_INFINITY;
        int y = -1;
        for (int j = 0; j < this.k; ++j) {
            posteriori[j] = 0.0;
            for (int i3 = 0; i3 < this.T; ++i3) {
                int n = j;
                posteriori[n] = posteriori[n] + this.shrinkage * this.forest[j][i3].Predict(x);
            }
            if (!(posteriori[j] > max)) continue;
            max = posteriori[j];
            y = j;
        }
        double Z = 0.0;
        for (i = 0; i < this.k; ++i) {
            posteriori[i] = Math.exp(posteriori[i] - max);
            Z += posteriori[i];
        }
        i = 0;
        while (i < this.k) {
            int n = i++;
            posteriori[n] = posteriori[n] / Z;
        }
        return y;
    }

    @Override
    public IClassifier clone() {
        try {
            return (IClassifier)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported: " + ex.getMessage());
        }
    }

    class LKNodeOutput
    implements RegressionTree.NodeOutput,
    Serializable {
        double[] y;

        public LKNodeOutput(double[] response) {
            this.y = response;
        }

        @Override
        public double calculate(int[] samples) {
            int n = 0;
            double nu = 0.0;
            double de = 0.0;
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] <= 0) continue;
                ++n;
                double abs = Math.abs(this.y[i]);
                nu += this.y[i];
                de += abs * (1.0 - abs);
            }
            if (de < 1.0E-10) {
                return nu / (double)n;
            }
            return ((double)GradientBoostingTree.this.k - 1.0) / (double)GradientBoostingTree.this.k * (nu / de);
        }
    }

    class L2NodeOutput
    implements RegressionTree.NodeOutput {
        double[] y;

        public L2NodeOutput(double[] y) {
            this.y = y;
        }

        @Override
        public double calculate(int[] samples) {
            double nu = 0.0;
            double de = 0.0;
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] <= 0) continue;
                double abs = Math.abs(this.y[i]);
                nu += this.y[i];
                de += abs * (2.0 - abs);
            }
            return nu / de;
        }
    }
}

