/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;

public class WeberLocalDescriptor {
    private final int beta = 5;
    private final double epsilon = 1.0E-7;
    private int alpha = 3;
    private double[][] differentialExcitation;
    private double[][] gradientOrientation;
    private final int[][] kernel = new int[][]{{1, 1, 1}, {1, -8, 1}, {1, 1, 1}};

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public double[][] getGradientOrientation() {
        return this.gradientOrientation;
    }

    public double[][] Compute(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            this.differentialExcitation = new double[height - 1][width - 1];
            this.gradientOrientation = new double[height - 1][width - 1];
            for (int i = 1; i < height - 1; ++i) {
                for (int j = 1; j < width - 1; ++j) {
                    double v00 = this.kernel[0][0] * fastBitmap.getGray(i - 1, j - 1) + this.kernel[0][1] * fastBitmap.getGray(i - 1, j) + this.kernel[0][2] * fastBitmap.getGray(i - 1, j + 1) + this.kernel[1][0] * fastBitmap.getGray(i, j - 1) + this.kernel[1][1] * fastBitmap.getGray(i, j) + this.kernel[1][2] * fastBitmap.getGray(i, j + 1) + this.kernel[2][0] * fastBitmap.getGray(i + 1, j - 1) + this.kernel[2][1] * fastBitmap.getGray(i + 1, j) + this.kernel[2][2] * fastBitmap.getGray(i + 1, j + 1);
                    double v01 = fastBitmap.getGray(i, j) + 5;
                    this.differentialExcitation[i - 1][j - 1] = v01 != 0.0 ? Math.atan((double)this.alpha * v00 / v01) : 0.1;
                    int n1 = fastBitmap.getGray(i - 1, j);
                    int n3 = fastBitmap.getGray(i, j + 1);
                    int n5 = fastBitmap.getGray(i + 1, j);
                    int n7 = fastBitmap.getGray(i, j - 1);
                    if ((double)Math.abs(n7 - n3) < 1.0E-7) {
                        this.gradientOrientation[i - 1][j - 1] = 0.0;
                        continue;
                    }
                    double v10 = n5 - n1;
                    double v11 = n7 - n3;
                    this.gradientOrientation[i - 1][j - 1] = Math.atan(v10 / v11) * 180.0 / Math.PI;
                    if (v11 > 1.0E-7 && v10 > 1.0E-7) {
                        double[] dArray = this.gradientOrientation[i - 1];
                        int n = j - 1;
                        dArray[n] = dArray[n] + 0.0;
                        continue;
                    }
                    if (v11 < -1.0E-7 && v10 > 1.0E-7) {
                        double[] dArray = this.gradientOrientation[i - 1];
                        int n = j - 1;
                        dArray[n] = dArray[n] + 180.0;
                        continue;
                    }
                    if (v11 < -1.0E-7 && v10 < -1.0E-7) {
                        double[] dArray = this.gradientOrientation[i - 1];
                        int n = j - 1;
                        dArray[n] = dArray[n] + 180.0;
                        continue;
                    }
                    if (!(v11 > 1.0E-7) || !(v10 < -1.0E-7)) continue;
                    double[] dArray = this.gradientOrientation[i - 1];
                    int n = j - 1;
                    dArray[n] = dArray[n] + 360.0;
                }
            }
            return this.differentialExcitation;
        }
        throw new IllegalArgumentException("Weber Local Descriptor only works in grayscale images.");
    }

    public FastBitmap toFastBitmap() {
        FastBitmap fb = new FastBitmap(this.differentialExcitation[0].length, this.differentialExcitation.length, FastBitmap.ColorSpace.Grayscale);
        for (int i = 0; i < this.differentialExcitation.length; ++i) {
            for (int j = 0; j < this.differentialExcitation[0].length; ++j) {
                fb.setGray(i, j, (int)(255.0 * (this.differentialExcitation[i][j] - -1.5707963267948966) / Math.PI));
            }
        }
        return fb;
    }
}

