/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.DistanceTransform;
import Catalano.Imaging.Filters.Invert;
import Catalano.Imaging.Tools.Blob;
import Catalano.Imaging.Tools.BlobDetection;
import Catalano.Math.Distances.Distance;
import Catalano.Math.Matrix;
import java.util.ArrayList;
import java.util.List;

public final class ShapeDescriptors {
    private ShapeDescriptors() {
    }

    public static int Area(FastBitmap fastBitmap) {
        int area = 0;
        for (int x = 0; x < fastBitmap.getHeight(); ++x) {
            for (int y = 0; y < fastBitmap.getWidth(); ++y) {
                if (fastBitmap.getGray(x, y) != 255) continue;
                ++area;
            }
        }
        return area;
    }

    public static double AreaEquivalentDiameter(int area) {
        double v = 1.2732395447351628;
        return Math.sqrt(v * (double)area);
    }

    public double Circularity(int area, int perimeter) {
        double v = Math.PI * 4;
        return v * (double)area / (double)(perimeter * perimeter);
    }

    public double Compactness(int area, double feretDiameter) {
        return ShapeDescriptors.AreaEquivalentDiameter(area) / feretDiameter;
    }

    public static int EulerNumber(FastBitmap fastBitmap) {
        Invert inv = new Invert();
        inv.applyInPlace(fastBitmap);
        BlobDetection bd = new BlobDetection();
        List<Blob> blobs = bd.ProcessImage(fastBitmap);
        int size = blobs.size() - 1;
        if (size < 0) {
            return 0;
        }
        return size;
    }

    public static double FeretDiameter(List<IntPoint> contour) {
        double maxDiameter = 0.0;
        for (IntPoint p : contour) {
            for (IntPoint pp : contour) {
                double d = Distance.SquaredEuclidean(p.x, p.y, pp.x, pp.y);
                if (!(d > maxDiameter)) continue;
                maxDiameter = d;
            }
        }
        return Math.sqrt(maxDiameter);
    }

    public static List<IntPoint> FeretPoints(List<IntPoint> contour) {
        ArrayList<IntPoint> lst = new ArrayList<IntPoint>();
        IntPoint p1 = new IntPoint();
        IntPoint p2 = new IntPoint();
        double maxDiameter = 0.0;
        for (IntPoint p : contour) {
            for (IntPoint pp : contour) {
                double d = Distance.SquaredEuclidean(p.x, p.y, pp.x, pp.y);
                if (!(d > maxDiameter)) continue;
                maxDiameter = d;
                p1 = p;
                p2 = pp;
            }
        }
        lst.add(p1);
        lst.add(p2);
        return lst;
    }

    public static double Irregularity(double thinnessRatio) {
        return 1.0 / thinnessRatio;
    }

    public static double MaximumErrorCircularity(double mcc, double mic) {
        return mcc - mic;
    }

    public static double MaximumInscribedCircle(FastBitmap fastBitmap) {
        DistanceTransform dt = new DistanceTransform();
        float[][] dist = dt.Compute(fastBitmap);
        return Matrix.Max(dist);
    }

    public static double MinimumCircumscribedCircle(IntPoint starPoint, List<IntPoint> contour) {
        double max = Double.MIN_VALUE;
        for (IntPoint p : contour) {
            double d = Distance.SquaredEuclidean(p, starPoint);
            if (!(d > max)) continue;
            max = d;
        }
        return Math.sqrt(max);
    }

    public static IntPoint StarPoint(FastBitmap fastBitmap) {
        DistanceTransform dt = new DistanceTransform();
        float[][] dist = dt.Compute(fastBitmap);
        return Matrix.MaxIndex(dist);
    }

    public static double PerimeterEquivalentDiameter(int area) {
        return (double)area / Math.PI;
    }

    public static double Roughness(int width, int height) {
        return width / height;
    }

    public static double Roundness(int area, double feretDiameter) {
        return (double)(4 * area) / (Math.PI * (feretDiameter * feretDiameter));
    }

    public static double Shape(int area, int perimeter) {
        return perimeter * perimeter / area;
    }

    public static double ThinnessRatio(int area, int perimeter) {
        double v = Math.PI * 4;
        return v * (double)(area / perimeter);
    }

    public static List<IntPoint> UltimateErodedPoints(FastBitmap fastBitmap) {
        ArrayList<IntPoint> points = new ArrayList<IntPoint>();
        DistanceTransform dt = new DistanceTransform();
        float[][] dist = dt.Compute(fastBitmap);
        BlobDetection bd = new BlobDetection();
        List<Blob> blobs = bd.ProcessImage(fastBitmap);
        for (Blob blob : blobs) {
            List<IntPoint> lst = blob.getPoints();
            float max = 0.0f;
            for (IntPoint p : lst) {
                if (!(dist[p.x][p.y] > max)) continue;
                max = dist[p.x][p.y];
            }
            for (IntPoint p : lst) {
                if (dist[p.x][p.y] != max) continue;
                points.add(new IntPoint(p));
            }
        }
        return points;
    }
}

