/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;

public class ObjectiveFidelity {
    private FastBitmap original;
    private FastBitmap reconstructed;

    public FastBitmap getOriginalImage() {
        return this.original;
    }

    public void setOriginalImage(FastBitmap original) {
        this.original = original;
    }

    public FastBitmap getReconstructedImage() {
        return this.reconstructed;
    }

    public void setReconstructedImage(FastBitmap reconstructed) {
        this.reconstructed = reconstructed;
    }

    public ObjectiveFidelity(FastBitmap original, FastBitmap reconstructed) {
        this.original = original;
        this.reconstructed = reconstructed;
        if (original.getWidth() != reconstructed.getWidth() || original.getHeight() != reconstructed.getHeight()) {
            throw new IllegalArgumentException("The both images must be equal dimensions");
        }
        if (original.getColorSpace() != reconstructed.getColorSpace()) {
            throw new IllegalArgumentException("The both images must be the same pixel format.");
        }
    }

    public int getTotalError() {
        int sumError = 0;
        for (int x = 0; x < this.original.getHeight(); ++x) {
            for (int y = 0; y < this.original.getWidth(); ++y) {
                sumError += Math.abs(this.reconstructed.getGray(x, y) - this.original.getGray(x, y));
            }
        }
        return sumError;
    }

    public double getMAE() {
        double sumError = 0.0;
        for (int x = 0; x < this.original.getHeight(); ++x) {
            for (int y = 0; y < this.original.getWidth(); ++y) {
                sumError += (double)Math.abs(this.reconstructed.getGray(x, y) - this.original.getGray(x, y));
            }
        }
        return 1.0 / (double)(this.original.getWidth() * this.original.getHeight()) * sumError;
    }

    public double getMSE() {
        int sumError = 0;
        for (int x = 0; x < this.original.getHeight(); ++x) {
            for (int y = 0; y < this.original.getWidth(); ++y) {
                double squareDiff = Math.pow(this.reconstructed.getGray(x, y) - this.original.getGray(x, y), 2.0);
                sumError = (int)((double)sumError + squareDiff);
            }
        }
        double size = 1.0 / (double)(this.original.getWidth() * this.original.getHeight());
        return Math.sqrt(size * (double)sumError);
    }

    public double getSNR() {
        double squareImg = 0.0;
        double squareRecon = 0.0;
        for (int x = 0; x < this.original.getHeight(); ++x) {
            for (int y = 0; y < this.original.getWidth(); ++y) {
                int g = this.reconstructed.getGray(x, y);
                squareRecon += (double)(g * g);
                squareImg += Math.pow(g - this.original.getGray(x, y), 2.0);
            }
        }
        if (squareImg == 0.0) {
            return 0.0;
        }
        return Math.sqrt(squareRecon / squareImg);
    }

    public double getDSNR() {
        int w = this.original.getWidth();
        int h = this.original.getHeight();
        double sumGradO = 0.0;
        double sumGradDiff = 0.0;
        for (int i = 0; i < h - 1; ++i) {
            for (int j = 0; j < w - 1; ++j) {
                int gradO = Math.abs(this.original.getGray(i, j) - this.original.getGray(i + 1, j)) + Math.abs(this.original.getGray(i, j) - this.original.getGray(i, j + 1));
                sumGradO += (double)(gradO * gradO);
                int gradR = Math.abs(this.reconstructed.getGray(i, j) - this.reconstructed.getGray(i + 1, j)) + Math.abs(this.reconstructed.getGray(i, j) - this.reconstructed.getGray(i, j + 1));
                sumGradDiff += Math.pow(gradO - gradR, 2.0);
            }
        }
        if (sumGradDiff == 0.0) {
            return 0.0;
        }
        double r = sumGradO / sumGradDiff;
        return 10.0 * Math.log10(r);
    }

    public double getPSNR() {
        return this.getPSNR(256);
    }

    public double getPSNR(int l) {
        double sum = 0.0;
        for (int x = 0; x < this.original.getHeight(); ++x) {
            for (int y = 0; y < this.original.getWidth(); ++y) {
                sum += Math.pow(this.reconstructed.getGray(x, y) - this.original.getGray(x, y), 2.0);
            }
        }
        if (sum == 0.0) {
            return 0.0;
        }
        int size = this.original.getWidth() * this.original.getHeight();
        sum = 1.0 / (double)size * sum;
        sum = (double)(l * l) / sum;
        sum = 10.0 * Math.log10(sum);
        return sum;
    }

    public double getUniversalQualityIndex() {
        double xMean = 0.0;
        double yMean = 0.0;
        int width = this.original.getWidth();
        int height = this.original.getHeight();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                xMean += (double)this.original.getGray(i, j);
                yMean += (double)this.reconstructed.getGray(i, j);
            }
        }
        xMean /= (double)(width * height);
        yMean /= (double)(width * height);
        double xStd = 0.0;
        double yStd = 0.0;
        double xyStd = 0.0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                xStd += Math.pow((double)this.original.getGray(i, j) - xMean, 2.0);
                yStd += Math.pow((double)this.reconstructed.getGray(i, j) - yMean, 2.0);
                xyStd += ((double)this.original.getGray(i, j) - xMean) * ((double)this.reconstructed.getGray(i, j) - yMean);
            }
        }
        return 4.0 * (xyStd /= (double)(width * height - 1)) * xMean * yMean / (((xStd /= (double)(width * height - 1)) + (yStd /= (double)(width * height - 1))) * (xMean * xMean + yMean * yMean));
    }
}

