/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.HuMoments;
import Catalano.Imaging.Tools.ImageMoments;

public class MaitraMoments {
    private boolean normalize;

    public MaitraMoments() {
    }

    public MaitraMoments(boolean normalize) {
        this.normalize = normalize;
    }

    public double[] Compute(FastBitmap fastBitmap) {
        double[] result = new double[6];
        HuMoments hu = new HuMoments();
        double[] m = hu.Compute(fastBitmap);
        double u00 = ImageMoments.getNormalizedCentralMoment(fastBitmap, 0, 0);
        result[0] = Math.sqrt(m[1]) / m[0];
        result[1] = m[2] * u00 / (m[1] * m[0]);
        result[2] = m[3] / m[2];
        result[3] = Math.sqrt(m[4]) / m[3];
        result[4] = m[5] / (m[3] * m[0]);
        result[5] = m[6] / m[4];
        if (this.normalize) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = Math.signum(result[i]) * Math.log10(Math.abs(result[i]) + 1.0);
            }
        }
        return result;
    }
}

