/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Math.Matrix;
import Catalano.Math.Tools;

public class ImageUtils {
    public static double[][] Convolution(double[][] image, double[][] kernel) {
        return ImageUtils.Convolution(image, kernel, true);
    }

    public static double[][] Convolution(double[][] image, double[][] kernel, boolean replicate) {
        int width = image[0].length;
        int height = image.length;
        double[][] result = new double[height][width];
        int lines = (kernel.length - 1) / 2;
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                double gray = 0.0;
                for (int i = 0; i < kernel.length; ++i) {
                    int Xline = x + (i - lines);
                    for (int j = 0; j < kernel[0].length; ++j) {
                        int Yline = y + (j - lines);
                        if (Xline >= 0 && Xline < height && Yline >= 0 && Yline < width) {
                            gray += kernel[i][j] * image[Xline][Yline];
                            continue;
                        }
                        if (!replicate) continue;
                        int r = x + i - lines;
                        int c = y + j - lines;
                        if (r < 0) {
                            r = 0;
                        }
                        if (r >= height) {
                            r = height - 1;
                        }
                        if (c < 0) {
                            c = 0;
                        }
                        if (c >= width) {
                            c = width - 1;
                        }
                        gray += kernel[i][j] * image[r][c];
                    }
                }
                result[x][y] = gray;
            }
        }
        return result;
    }

    public static double[][][] Convolution(double[][][] image, double[][] kernel) {
        return ImageUtils.Convolution(image, kernel, true);
    }

    public static double[][][] Convolution(double[][][] image, double[][] kernel, boolean replicate) {
        int width = image[0].length;
        int height = image.length;
        double[][][] result = new double[height][width][3];
        int lines = (kernel.length - 1) / 2;
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                double blue = 0.0;
                double green = 0.0;
                double red = 0.0;
                for (int i = 0; i < kernel.length; ++i) {
                    int Xline = x + (i - lines);
                    for (int j = 0; j < kernel[0].length; ++j) {
                        int Yline = y + (j - lines);
                        if (Xline >= 0 && Xline < height && Yline >= 0 && Yline < width) {
                            red += kernel[i][j] * image[Xline][Yline][0];
                            green += kernel[i][j] * image[Xline][Yline][1];
                            blue += kernel[i][j] * image[Xline][Yline][2];
                            continue;
                        }
                        if (!replicate) continue;
                        int r = x + i - lines;
                        int c = y + j - lines;
                        if (r < 0) {
                            r = 0;
                        }
                        if (r >= height) {
                            r = height - 1;
                        }
                        if (c < 0) {
                            c = 0;
                        }
                        if (c >= width) {
                            c = width - 1;
                        }
                        red += kernel[i][j] * image[r][c][0];
                        green += kernel[i][j] * image[r][c][1];
                        blue += kernel[i][j] * image[r][c][2];
                    }
                }
                result[x][y][0] = red;
                result[x][y][1] = green;
                result[x][y][2] = blue;
            }
        }
        return result;
    }

    public static double[][] Convolution(double[][] image, double[] row, double[] col) {
        return ImageUtils.Convolution(image, row, col, true);
    }

    public static double[][] Convolution(double[][] image, double[] row, double[] col, boolean replicate) {
        int k;
        int j;
        int i;
        int width = image[0].length;
        int height = image.length;
        int lines = (row.length - 1) / 2;
        double[][] result = new double[height][width];
        double[][] copy = new double[height][width];
        for (int i2 = 0; i2 < copy.length; ++i2) {
            for (int j2 = 0; j2 < copy[0].length; ++j2) {
                copy[i2][j2] = image[i2][j2];
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                double gray = 0.0;
                for (k = 0; k < row.length; ++k) {
                    int Yline = j - lines + k;
                    if (Yline >= 0 && Yline < width) {
                        gray += row[k] * image[i][Yline];
                        continue;
                    }
                    if (!replicate) continue;
                    int c = j + k - lines;
                    if (c < 0) {
                        c = 0;
                    }
                    if (c >= width) {
                        c = width - 1;
                    }
                    gray += row[row.length - k - 1] * image[i][c];
                }
                copy[i][j] = gray;
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                double gray = 0.0;
                for (k = 0; k < col.length; ++k) {
                    int Xline = i - lines + k;
                    if (Xline >= 0 && Xline < height) {
                        gray += col[k] * copy[Xline][j];
                        continue;
                    }
                    if (!replicate) continue;
                    int r = i + k - lines;
                    if (r < 0) {
                        r = 0;
                    }
                    if (r >= height) {
                        r = height - 1;
                    }
                    gray += col[k] * copy[r][j];
                }
                result[i][j] = gray;
            }
        }
        return result;
    }

    public static double[][][] Convolution(double[][][] image, double[] row, double[] col) {
        return ImageUtils.Convolution(image, row, col, true);
    }

    public static double[][][] Convolution(double[][][] image, double[] row, double[] col, boolean replicate) {
        int k;
        double green;
        double blue;
        int j;
        int i;
        int width = image[0].length;
        int height = image.length;
        int lines = (row.length - 1) / 2;
        double[][][] result = new double[height][width][3];
        double[][][] copy = new double[height][width][3];
        for (int i2 = 0; i2 < copy.length; ++i2) {
            for (int j2 = 0; j2 < copy[0].length; ++j2) {
                copy[i2][j2][0] = image[i2][j2][0];
                copy[i2][j2][1] = image[i2][j2][1];
                copy[i2][j2][2] = image[i2][j2][2];
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                blue = 0.0;
                green = 0.0;
                double red = 0.0;
                for (k = 0; k < row.length; ++k) {
                    int Yline = j - lines + k;
                    if (Yline >= 0 && Yline < width) {
                        red += row[k] * image[i][Yline][0];
                        green += row[k] * image[i][Yline][1];
                        blue += row[k] * image[i][Yline][2];
                        continue;
                    }
                    if (!replicate) continue;
                    int c = j + k - lines;
                    if (c < 0) {
                        c = 0;
                    }
                    if (c >= width) {
                        c = width - 1;
                    }
                    red += row[row.length - k - 1] * image[i][c][0];
                    green += row[row.length - k - 1] * image[i][c][1];
                    blue += row[row.length - k - 1] * image[i][c][2];
                }
                copy[i][j][0] = red;
                copy[i][j][1] = green;
                copy[i][j][2] = blue;
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                blue = 0.0;
                green = 0.0;
                double red = 0.0;
                for (k = 0; k < col.length; ++k) {
                    int Xline = i - lines + k;
                    if (Xline >= 0 && Xline < height) {
                        red += col[k] * copy[Xline][j][0];
                        green += col[k] * copy[Xline][j][1];
                        blue += col[k] * copy[Xline][j][2];
                        continue;
                    }
                    if (!replicate) continue;
                    int r = i + k - lines;
                    if (r < 0) {
                        r = 0;
                    }
                    if (r >= height) {
                        r = height - 1;
                    }
                    red += col[k] * copy[r][j][0];
                    green += col[k] * copy[r][j][1];
                    blue += col[k] * copy[r][j][2];
                }
                result[i][j][0] = red;
                result[i][j][1] = green;
                result[i][j][2] = blue;
            }
        }
        return result;
    }

    public static void Normalize(int[][] image) {
        ImageUtils.Normalize(image, 0, 255);
    }

    public static void Normalize(int[][] image, int min, int max) {
        int[] mm = Matrix.MinMax(image);
        for (int i = 0; i < image.length; ++i) {
            for (int j = 0; j < image[0].length; ++j) {
                image[i][j] = (int)Tools.Scale(mm[0], mm[1], min, max, image[i][j]);
            }
        }
    }

    public static void Normalize(double[][] image) {
        ImageUtils.Normalize(image, 0.0, 255.0);
    }

    public static void Normalize(double[][] image, double min, double max) {
        double[] mm = Matrix.MinMax(image);
        for (int i = 0; i < image.length; ++i) {
            for (int j = 0; j < image[0].length; ++j) {
                image[i][j] = (int)Tools.Scale(mm[0], mm[1], min, max, image[i][j]);
            }
        }
    }

    public static void Normalize(double[][][] image) {
        ImageUtils.Normalize(image, 0.0, 255.0);
    }

    public static void Normalize(double[][][] image, double min, double max) {
        int j;
        int i;
        double minBlue = Double.MAX_VALUE;
        double minGreen = Double.MAX_VALUE;
        double minRed = Double.MAX_VALUE;
        double maxBlue = -1.7976931348623157E308;
        double maxGreen = -1.7976931348623157E308;
        double maxRed = -1.7976931348623157E308;
        for (i = 0; i < image.length; ++i) {
            for (j = 0; j < image[0].length; ++j) {
                minRed = Math.min(minRed, image[i][j][0]);
                minGreen = Math.min(minGreen, image[i][j][1]);
                minBlue = Math.min(minBlue, image[i][j][2]);
                maxRed = Math.max(maxRed, image[i][j][0]);
                maxGreen = Math.max(maxGreen, image[i][j][1]);
                maxBlue = Math.max(maxBlue, image[i][j][2]);
            }
        }
        for (i = 0; i < image.length; ++i) {
            for (j = 0; j < image[0].length; ++j) {
                image[i][j][0] = (int)Tools.Scale(minRed, maxRed, min, max, image[i][j][0]);
                image[i][j][1] = (int)Tools.Scale(minGreen, maxGreen, min, max, image[i][j][1]);
                image[i][j][2] = (int)Tools.Scale(minBlue, maxBlue, min, max, image[i][j][2]);
            }
        }
    }
}

