/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.ArraysUtil;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ConvolutionKernel;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;

public class FastRadialSymmetryTransform
implements IApplyInPlace {
    private int radius = 2;
    private float kappa = 8.0f;
    private int alpha = 1;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(2, radius);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public FastRadialSymmetryTransform() {
    }

    public FastRadialSymmetryTransform(int radius) {
        this.setRadius(radius);
    }

    public FastRadialSymmetryTransform(int radius, int alpha) {
        this.radius = radius;
        this.alpha = alpha;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        double[][] symmetryMap;
        if (fastBitmap.isGrayscale()) {
            int j;
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            double[][] imageH = this.Convolution(fastBitmap, ArraysUtil.toDouble(ConvolutionKernel.SobelHorizontal));
            double[][] imageV = this.Convolution(fastBitmap, ArraysUtil.toDouble(ConvolutionKernel.SobelVertical));
            symmetryMap = new double[height][width];
            double[][] mag = this.Magnitude(imageH, imageV);
            this.Normalize(imageH, mag);
            this.Normalize(imageV, mag);
            int[][] mapX = new int[height][width];
            int[][] mapY = new int[height][width];
            for (int i = 0; i < height; ++i) {
                int index = 1;
                for (j = 0; j < width; ++j) {
                    mapX[i][j] = index++;
                }
            }
            int index = 1;
            for (int i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    mapY[i][j] = index;
                }
                ++index;
            }
            int[][] posX = new int[height][width];
            int[][] posY = new int[height][width];
            int[][] negX = new int[height][width];
            int[][] negY = new int[height][width];
            for (int r = 1; r < this.radius; ++r) {
                int j2;
                int i;
                double[][] m = new double[height][width];
                double[][] o = new double[height][width];
                for (i = 0; i < height; ++i) {
                    for (j2 = 0; j2 < width; ++j2) {
                        posX[i][j2] = mapX[i][j2] + (int)Math.round((double)r * imageV[i][j2]);
                        negX[i][j2] = mapX[i][j2] - (int)Math.round((double)r * imageV[i][j2]);
                        if (posX[i][j2] < 1) {
                            posX[i][j2] = 1;
                        }
                        if (negX[i][j2] < 1) {
                            negX[i][j2] = 1;
                        }
                        if (posX[i][j2] > width) {
                            posX[i][j2] = width;
                        }
                        if (negX[i][j2] <= width) continue;
                        negX[i][j2] = width;
                    }
                }
                for (i = 0; i < height; ++i) {
                    for (j2 = 0; j2 < width; ++j2) {
                        posY[i][j2] = mapY[i][j2] + (int)Math.round((double)r * imageH[i][j2]);
                        negY[i][j2] = mapY[i][j2] - (int)Math.round((double)r * imageH[i][j2]);
                        if (posY[i][j2] < 1) {
                            posY[i][j2] = 1;
                        }
                        if (negY[i][j2] < 1) {
                            negY[i][j2] = 1;
                        }
                        if (posY[i][j2] > height) {
                            posY[i][j2] = height;
                        }
                        if (negY[i][j2] <= height) continue;
                        negY[i][j2] = height;
                    }
                }
                for (i = 0; i < height; ++i) {
                    for (j2 = 0; j2 < width; ++j2) {
                        double[] dArray = o[posY[i][j2] - 1];
                        int n = posX[i][j2] - 1;
                        dArray[n] = dArray[n] + 1.0;
                        double[] dArray2 = o[negY[i][j2] - 1];
                        int n2 = negX[i][j2] - 1;
                        dArray2[n2] = dArray2[n2] - 1.0;
                        double[] dArray3 = m[posY[i][j2] - 1];
                        int n3 = posX[i][j2] - 1;
                        dArray3[n3] = dArray3[n3] + mag[i][j2];
                        double[] dArray4 = m[negY[i][j2] - 1];
                        int n4 = negX[i][j2] - 1;
                        dArray4[n4] = dArray4[n4] - mag[i][j2];
                    }
                }
                this.kappa = r == 1 ? 8.0f : 9.9f;
                for (i = 0; i < o.length; ++i) {
                    for (j2 = 0; j2 < o[0].length; ++j2) {
                        if (o[i][j2] > (double)this.kappa) {
                            o[i][j2] = this.kappa;
                        }
                        if (!(o[i][j2] < (double)(-this.kappa))) continue;
                        o[i][j2] = -this.kappa;
                    }
                }
                double[][] f = new double[height][width];
                for (int i2 = 0; i2 < height; ++i2) {
                    for (int j3 = 0; j3 < width; ++j3) {
                        f[i2][j3] = m[i2][j3] / (double)this.kappa * Math.pow(Math.abs(o[i2][j3]) / (double)this.kappa, this.alpha);
                    }
                }
                double[][] gk = this.Gaussian(this.radius, 0.25 * (double)this.radius);
                gk = Matrix.Multiply(gk, (double)this.radius);
                double[][] fin = this.Convolution(f, gk);
                for (int i3 = 0; i3 < height; ++i3) {
                    for (int j4 = 0; j4 < width; ++j4) {
                        double[] dArray = symmetryMap[i3];
                        int n = j4;
                        dArray[n] = dArray[n] + fin[i3][j4];
                    }
                }
            }
            for (int i = 0; i < height; ++i) {
                int j5 = 0;
                while (j5 < width) {
                    double[] dArray = symmetryMap[i];
                    int n = j5++;
                    dArray[n] = dArray[n] / (double)this.radius;
                }
            }
            double min = Matrix.Min(symmetryMap);
            double max = Matrix.Max(symmetryMap);
            for (int i = 0; i < height; ++i) {
                for (int j6 = 0; j6 < width; ++j6) {
                    symmetryMap[i][j6] = Tools.Scale(min, max, 0.0, 255.0, symmetryMap[i][j6]);
                }
            }
        } else {
            throw new IllegalArgumentException("Fast Radial Symmetry Transform only works in grayscale images.");
        }
        fastBitmap.matrixToImage(symmetryMap);
    }

    private double[][] Gaussian(int size, double sigma) {
        int j;
        int i;
        double[][] k = new double[size][size];
        double sum = 0.0;
        for (i = 0; i < k.length; ++i) {
            for (j = 0; j < k[0].length; ++j) {
                double v;
                double ij = i * i + j * j;
                k[i][j] = v = Math.exp(-ij / Math.pow(2.0 * sigma, 2.0));
                sum += v;
            }
        }
        for (i = 0; i < k.length; ++i) {
            j = 0;
            while (j < k[0].length) {
                double[] dArray = k[i];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
        }
        return k;
    }

    private void Normalize(double[][] image, double[][] mag) {
        for (int i = 0; i < image.length; ++i) {
            for (int j = 0; j < image[0].length; ++j) {
                double[] dArray = image[i];
                int n = j;
                dArray[n] = dArray[n] / mag[i][j];
            }
        }
    }

    private double[][] Magnitude(double[][] H, double[][] V) {
        double[][] mag = new double[H.length][H[0].length];
        for (int i = 0; i < H.length; ++i) {
            for (int j = 0; j < H[0].length; ++j) {
                mag[i][j] = (double)((float)Math.sqrt(H[i][j] * H[i][j] + V[i][j] * V[i][j])) + 2.2204E-16;
            }
        }
        return mag;
    }

    private double[][] Convolution(double[][] A, double[][] kernel) {
        int height = A.length;
        int width = A[0].length;
        double[][] image = new double[height][width];
        int lines = this.CalcLines(kernel);
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                int gray = 0;
                for (int i = 0; i < kernel.length; ++i) {
                    int Xline = x + (i - lines);
                    for (int j = 0; j < kernel[0].length; ++j) {
                        int Yline = y + (j - lines);
                        if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                        gray = (int)((double)gray + kernel[i][j] * A[Xline][Yline]);
                    }
                }
                image[x][y] = gray;
            }
        }
        return image;
    }

    private double[][] Convolution(FastBitmap fastBitmap, double[][] kernel) {
        int height = fastBitmap.getHeight();
        int width = fastBitmap.getWidth();
        double[][] image = new double[height][width];
        int lines = this.CalcLines(kernel);
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                int gray = 0;
                for (int i = 0; i < kernel.length; ++i) {
                    int Xline = x + (i - lines);
                    for (int j = 0; j < kernel[0].length; ++j) {
                        int Yline = y + (j - lines);
                        if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                        gray = (int)((double)gray + kernel[i][j] * (double)fastBitmap.getGray(Xline, Yline));
                    }
                }
                image[x][y] = gray;
            }
        }
        return image;
    }

    private int CalcLines(double[][] kernel) {
        int lines = (kernel[0].length - 1) / 2;
        return lines;
    }
}

