/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.FloatPoint;
import java.io.Serializable;
import java.util.List;

public class Curve
implements Serializable {
    public float[] x;
    public float[] y;

    public float[] getX() {
        return this.x;
    }

    public void setX(float[] x) {
        this.x = x;
    }

    public float[] getY() {
        return this.y;
    }

    public void setY(float[] y) {
        this.y = y;
    }

    public void setXY(float[] x, float[] y) {
        this.x = x;
        this.y = y;
    }

    public Curve() {
        this.x = new float[0];
        this.y = new float[0];
    }

    public Curve(Curve curve) {
        this.x = (float[])curve.x.clone();
        this.y = (float[])curve.y.clone();
    }

    public Curve(float[] x, float[] y) {
        this.x = x;
        this.y = y;
    }

    public void addPoint(List<FloatPoint> points) {
        for (FloatPoint p : points) {
            this.addPoint(p);
        }
    }

    public void addPoint(FloatPoint point) {
        this.addPoint(point.x, point.y);
    }

    public void addPoint(float kx, float ky) {
        int pos = -1;
        int numKnots = this.x.length;
        float[] nx = new float[numKnots + 1];
        float[] ny = new float[numKnots + 1];
        int j = 0;
        for (int i = 0; i < numKnots; ++i) {
            if (pos == -1 && this.x[i] > kx) {
                pos = j;
                nx[j] = kx;
                ny[j] = ky;
                ++j;
            }
            nx[j] = this.x[i];
            ny[j] = this.y[i];
            ++j;
        }
        if (pos == -1) {
            nx[j] = kx;
            ny[j] = ky;
        }
        this.x = nx;
        this.y = ny;
    }

    public void removePoint(int index) {
        int numKnots = this.x.length;
        if (numKnots <= 2) {
            return;
        }
        float[] nx = new float[numKnots - 1];
        float[] ny = new float[numKnots - 1];
        int j = 0;
        for (int i = 0; i < numKnots - 1; ++i) {
            if (i == index) {
                ++j;
            }
            nx[i] = this.x[j];
            ny[i] = this.y[j];
            ++j;
        }
        this.x = nx;
        this.y = ny;
    }

    public void clear() {
        this.y = null;
        this.x = null;
    }

    public int[] makeLut() {
        int numKnots = this.x.length;
        float[] nx = new float[numKnots + 2];
        float[] ny = new float[numKnots + 2];
        System.arraycopy(this.x, 0, nx, 1, numKnots);
        System.arraycopy(this.y, 0, ny, 1, numKnots);
        nx[0] = nx[1];
        ny[0] = ny[1];
        nx[numKnots + 1] = nx[numKnots];
        ny[numKnots + 1] = ny[numKnots];
        int[] table = new int[256];
        for (int i = 0; i < 1024; ++i) {
            float f = (float)i / 1024.0f;
            int x = (int)(255.0f * Curve.Spline(f, nx.length, nx) + 0.5f);
            int y = (int)(255.0f * Curve.Spline(f, nx.length, ny) + 0.5f);
            x = x > 255 ? 255 : x;
            x = x < 0 ? 0 : x;
            y = y > 255 ? 255 : y;
            table[x] = y = y < 0 ? 0 : y;
        }
        return table;
    }

    public static float Spline(float x, int numKnots, float[] knots) {
        int numSpans = numKnots - 3;
        if (numSpans < 1) {
            throw new IllegalArgumentException("Too few knots in spline");
        }
        x = x > 1.0f ? 1.0f : x;
        x = x < 0.0f ? 0.0f : x;
        int span = (int)(x *= (float)numSpans);
        if (span > numKnots - 4) {
            span = numKnots - 4;
        }
        x -= (float)span;
        float k0 = knots[span];
        float k1 = knots[span + 1];
        float k2 = knots[span + 2];
        float k3 = knots[span + 3];
        float c3 = -0.5f * k0 + 1.5f * k1 + -1.5f * k2 + 0.5f * k3;
        float c2 = 1.0f * k0 + -2.5f * k1 + 2.0f * k2 + -0.5f * k3;
        float c1 = -0.5f * k0 + 0.0f * k1 + 0.5f * k2 + 0.0f * k3;
        float c0 = 0.0f * k0 + 1.0f * k1 + 0.0f * k2 + 0.0f * k3;
        return ((c3 * x + c2) * x + c1) * x + c0;
    }

    public static float Spline(float x, int numKnots, int[] xknots, int[] yknots) {
        int span;
        int numSpans = numKnots - 3;
        if (numSpans < 1) {
            throw new IllegalArgumentException("Too few knots in spline");
        }
        for (span = 0; span < numSpans && !((float)xknots[span + 1] > x); ++span) {
        }
        if (span > numKnots - 3) {
            span = numKnots - 3;
        }
        float t = (x - (float)xknots[span]) / (float)(xknots[span + 1] - xknots[span]);
        if (--span < 0) {
            span = 0;
            t = 0.0f;
        }
        float k0 = yknots[span];
        float k1 = yknots[span + 1];
        float k2 = yknots[span + 2];
        float k3 = yknots[span + 3];
        float c3 = -0.5f * k0 + 1.5f * k1 + -1.5f * k2 + 0.5f * k3;
        float c2 = 1.0f * k0 + -2.5f * k1 + 2.0f * k2 + -0.5f * k3;
        float c1 = -0.5f * k0 + 0.0f * k1 + 0.5f * k2 + 0.0f * k3;
        float c0 = 0.0f * k0 + 1.0f * k1 + 0.0f * k2 + 0.0f * k3;
        return ((c3 * t + c2) * t + c1) * t + c0;
    }
}

