/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture.BinaryPattern;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Texture.BinaryPattern.IBinaryPattern;
import Catalano.Imaging.Texture.BinaryPattern.LocalBinaryPattern;
import Catalano.Imaging.Tools.ImageHistogram;
import Catalano.Math.Matrix;

public class UniformLocalBinaryPattern
implements IBinaryPattern {
    private boolean nonUniform;

    public boolean isNonUniform() {
        return this.nonUniform;
    }

    public void setNonUniform(boolean nonUniform) {
        this.nonUniform = nonUniform;
    }

    public UniformLocalBinaryPattern() {
        this(true);
    }

    public UniformLocalBinaryPattern(boolean nonUniform) {
        this.nonUniform = nonUniform;
    }

    @Override
    public ImageHistogram ComputeFeatures(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Uniform LBP only works in grayscale images.");
        }
        LocalBinaryPattern lbp = new LocalBinaryPattern();
        return UniformLocalBinaryPattern.Encode(lbp.ComputeFeatures(fastBitmap), this.nonUniform);
    }

    public static ImageHistogram Encode(ImageHistogram hist) {
        return UniformLocalBinaryPattern.Encode(hist, true);
    }

    public static ImageHistogram Encode(ImageHistogram hist, boolean nonUniform) {
        int[] h = new int[59];
        int[] values = hist.getValues();
        int idx = 0;
        int nonU = 0;
        for (int i = 0; i < 256; ++i) {
            if (UniformLocalBinaryPattern.isUniform(i)) {
                h[idx] = values[i];
                ++idx;
                continue;
            }
            nonU += values[i];
        }
        h[58] = nonU;
        if (!nonUniform) {
            h = Matrix.RemoveColumn(h, 58);
        }
        return new ImageHistogram(h);
    }

    private static boolean isUniform(int x) {
        int n = UniformLocalBinaryPattern.trans(x);
        return n <= 2;
    }

    private static int trans(int x) {
        String a = String.format("%8s", Integer.toBinaryString(x)).replace(' ', '0');
        int dif = 0;
        for (int i = 1; i < a.length(); ++i) {
            if (a.charAt(i - 1) == a.charAt(i)) continue;
            ++dif;
        }
        if (a.charAt(7) != a.charAt(0)) {
            ++dif;
        }
        return dif;
    }
}

