/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture.BinaryPattern;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Texture.BinaryPattern.IBinaryPattern;
import Catalano.Imaging.Tools.ImageHistogram;

public class RankTransform
implements IBinaryPattern {
    @Override
    public ImageHistogram ComputeFeatures(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Rank Transform works only with grayscale images.");
        }
        int width = fastBitmap.getWidth() - 1;
        int height = fastBitmap.getHeight() - 1;
        int[] g = new int[256];
        for (int x = 1; x < height; ++x) {
            for (int y = 1; y < width; ++y) {
                int gray = fastBitmap.getGray(x, y);
                int sum = 0;
                if (gray - fastBitmap.getGray(x - 1, y - 1) >= 0) {
                    sum += 128;
                }
                if (gray - fastBitmap.getGray(x - 1, y) >= 0) {
                    sum += 64;
                }
                if (gray - fastBitmap.getGray(x - 1, y + 1) >= 0) {
                    sum += 32;
                }
                if (gray - fastBitmap.getGray(x, y + 1) >= 0) {
                    sum += 16;
                }
                if (gray - fastBitmap.getGray(x + 1, y + 1) >= 0) {
                    sum += 8;
                }
                if (gray - fastBitmap.getGray(x + 1, y) >= 0) {
                    sum += 4;
                }
                if (gray - fastBitmap.getGray(x + 1, y - 1) >= 0) {
                    sum += 2;
                }
                if (gray - fastBitmap.getGray(x, y - 1) >= 0) {
                    // empty if block
                }
                int n = ++sum;
                g[n] = g[n] + 1;
            }
        }
        return new ImageHistogram(g);
    }
}

