/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture.BinaryPattern;

import Catalano.Core.ArraysUtil;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Texture.BinaryPattern.IBinaryPattern;
import Catalano.Imaging.Tools.ImageHistogram;
import Catalano.Statistics.Tools;

public class LocalAdaptiveTernaryPattern
implements IBinaryPattern {
    private double constant;
    private ImageHistogram upperHistogram;
    private ImageHistogram lowerHistogram;

    public double getConstant() {
        return this.constant;
    }

    public void setConstant(double constant) {
        this.constant = constant;
    }

    public ImageHistogram getUpperHistogram() {
        return this.upperHistogram;
    }

    public ImageHistogram getLowerHistogram() {
        return this.lowerHistogram;
    }

    public LocalAdaptiveTernaryPattern() {
        this(1.0);
    }

    public LocalAdaptiveTernaryPattern(double constant) {
        this.constant = constant;
    }

    @Override
    public ImageHistogram ComputeFeatures(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Local Adaptive Ternary Pattern only works in grayscale images.");
        }
        int[] upper = new int[256];
        int[] lower = new int[256];
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        for (int i = 1; i < height - 1; ++i) {
            for (int j = 1; j < width - 1; ++j) {
                int k;
                int sumL = 0;
                int sumU = 0;
                int[][] ternary = this.TernaryMatrix(fastBitmap, i, j);
                int bin = 128;
                for (k = 0; k < 3; ++k) {
                    if (ternary[0][k] == 1) {
                        sumU += bin;
                    }
                    if (ternary[0][k] == -1) {
                        sumL += bin;
                    }
                    bin /= 2;
                }
                if (ternary[1][2] == 1) {
                    sumU += bin;
                }
                if (ternary[1][2] == -1) {
                    sumL += bin;
                }
                bin /= 2;
                for (k = 0; k < 3; ++k) {
                    if (ternary[2][2 - k] == 1) {
                        sumU += bin;
                    }
                    if (ternary[2][2 - k] == -1) {
                        sumL += bin;
                    }
                    bin /= 2;
                }
                int n = sumU;
                upper[n] = upper[n] + 1;
                int n2 = sumL;
                lower[n2] = lower[n2] + 1;
            }
        }
        this.upperHistogram = new ImageHistogram(upper);
        this.lowerHistogram = new ImageHistogram(lower);
        int[] all = ArraysUtil.Concatenate(upper, lower);
        return new ImageHistogram(all);
    }

    private int[][] TernaryMatrix(FastBitmap fastBitmap, int i, int j) {
        double[] values = new double[9];
        int idx = 0;
        for (int k = i - 1; k <= i + 1; ++k) {
            for (int l = j - 1; l <= j + 1; ++l) {
                values[idx++] = fastBitmap.getGray(k, l);
            }
        }
        double mean = Tools.Mean(values);
        double std = Tools.StandartDeviation(values, mean);
        double uThreshold = this.constant * (mean + std);
        double lThreshold = this.constant * (mean - std);
        int[][] ternary = new int[3][3];
        int x = 0;
        for (int k = i - 1; k <= i + 1; ++k) {
            int y = 0;
            for (int l = j - 1; l <= j + 1; ++l) {
                if ((double)fastBitmap.getGray(k, l) >= this.constant * uThreshold) {
                    ternary[x][y] = 1;
                }
                if ((double)fastBitmap.getGray(k, l) > this.constant * lThreshold && (double)fastBitmap.getGray(k, l) < this.constant * uThreshold) {
                    ternary[x][y] = 0;
                }
                if ((double)fastBitmap.getGray(k, l) <= this.constant * lThreshold) {
                    ternary[x][y] = -1;
                }
                ++y;
            }
            ++x;
        }
        return ternary;
    }
}

