/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Shapes;

import Catalano.Core.IntPoint;
import Catalano.Math.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IntPolygon {
    private int[] xPoints;
    private int[] yPoints;
    private int nPoints;

    public int[] getX() {
        if (this.xPoints.length == this.nPoints) {
            return this.xPoints;
        }
        return Arrays.copyOf(this.xPoints, this.nPoints);
    }

    public int[] getY() {
        if (this.yPoints.length == this.nPoints) {
            return this.yPoints;
        }
        return Arrays.copyOf(this.yPoints, this.nPoints);
    }

    public int getNPoints() {
        return this.nPoints;
    }

    public List<IntPoint> getPoints() {
        ArrayList<IntPoint> lst = new ArrayList<IntPoint>();
        for (int i = 0; i < this.nPoints; ++i) {
            lst.add(new IntPoint(this.xPoints[i], this.yPoints[i]));
        }
        return lst;
    }

    public IntPolygon() {
        this.xPoints = new int[4];
        this.yPoints = new int[4];
        this.nPoints = 0;
    }

    public IntPolygon(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The size of xPoints and yPoints must be the same.");
        }
        this.xPoints = Arrays.copyOf(x, x.length);
        this.yPoints = Arrays.copyOf(y, y.length);
        this.nPoints = x.length;
    }

    public IntPolygon(int[] x, int[] y, int nPoints) {
        if (x.length < nPoints || y.length < nPoints) {
            throw new IllegalArgumentException("the number of points is higher than lenght of xPoints or yPoints.");
        }
        if (nPoints < 0) {
            throw new NegativeArraySizeException("nPoints < 0");
        }
        this.xPoints = Arrays.copyOf(x, nPoints);
        this.yPoints = Arrays.copyOf(y, nPoints);
        this.nPoints = nPoints;
    }

    public IntPolygon(List<IntPoint> lstPoints) {
        this.nPoints = lstPoints.size();
        this.xPoints = new int[lstPoints.size()];
        this.yPoints = new int[lstPoints.size()];
        for (int i = 0; i < lstPoints.size(); ++i) {
            this.xPoints[i] = lstPoints.get((int)i).x;
            this.yPoints[i] = lstPoints.get((int)i).y;
        }
    }

    public IntPolygon(List<IntPoint> lstPoints, int nPoints) {
        if (lstPoints.size() < nPoints) {
            throw new IllegalArgumentException("the number of points is higher than lenght of lstPoints.");
        }
        if (nPoints < 0) {
            throw new NegativeArraySizeException("nPoints < 0");
        }
        this.nPoints = nPoints;
        this.xPoints = new int[nPoints];
        this.yPoints = new int[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            this.xPoints[i] = lstPoints.get((int)i).x;
            this.yPoints[i] = lstPoints.get((int)i).y;
        }
    }

    public void addPoint(IntPoint point) {
        this.addPoint(point.x, point.y);
    }

    public void addPoint(int x, int y) {
        if (this.nPoints >= this.xPoints.length || this.nPoints >= this.yPoints.length) {
            int newSize = this.nPoints * 2;
            if (!Tools.isPowerOf2(newSize)) {
                newSize = Integer.highestOneBit(newSize);
            }
            this.xPoints = Arrays.copyOf(this.xPoints, newSize);
            this.yPoints = Arrays.copyOf(this.yPoints, newSize);
        }
        this.xPoints[this.nPoints] = x;
        this.yPoints[this.nPoints] = y;
        ++this.nPoints;
    }
}

